-----------------------------------
-- Self-Destruct
-- Bomb Cluster Self Destruct - 3 Bombs up
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------

local m = Module:new("mobskill_self_destruct_3death")

xi.module.ensureTable("xi.actions.mobskills.self-destruct_3death")

m:addOverride("xi.actions.mobskills.self-destruct_3.onMobSkillCheck", function(target, mob, skill)
    if (mob:getHPP() > 66 or mob:getAnimationSub() ~= 4) and math.random() < .2 then -- 20% chance for all bombs to explode
        return 1
    end

    return 0
end)

m:addOverride("xi.actions.mobskills.self-destruct_3death.onMobWeaponSkill", function(target, mob, skill)
    local damage = skill:getMobHP() / 9
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, damage, xi.element.FIRE, 1, xi.mobskills.magicalTpBonus.NO_EFFECT, 0, 0, 1, 1.1, 1.2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

    mob:setHP(0)
    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
    return dmg
end)

return m
