-----------------------------------
-- Self-Destruct
-- Bomb Cluster Self Destruct - 3 Bombs up
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------

local m = Module:new("mobskill_self_destruct_3")

xi.module.ensureTable("xi.actions.mobskills.self-destruct_3")

m:addOverride("xi.actions.mobskills.self-destruct_3.onMobSkillCheck", function(target, mob, skill)
    if mob:getHPP() > 60 or mob:getAnimationSub() ~= 4 then
        return 1
    end

    return 0
end)

m:addOverride("xi.actions.mobskills.self-destruct_3.onMobWeaponSkill", function(target, mob, skill)
    local dmgmod = 1
    local bombTossHPP = skill:getMobHPP() / 100

    -- Razon - ENM: Fire in the Sky
    if mob:getHPP() <= 66 and mob:getPool() == 3333 then
        bombTossHPP = 0
    end

    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*18*bombTossHPP, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.MAB_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

    mob:setAnimationSub(5)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
    return dmg
end)

return m
