-----------------------------------
-- Saurian Slide
-- Damage, Strips main and sub weapons, temporary weapon Encumbrance.
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_saurian_slide')
local path = "xi.actions.mobskills.saurian_slide"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2
    local duration = math.random(30, 45)
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, xi.mobskills.shadowBehavior.NUMSHADOWS_3)
    
    if target:isPC() then
        target:unequipItem(xi.slot.MAIN)
        target:unequipItem(xi.slot.SUB)
        target:unequipItem(xi.slot.RANGED)
        target:unequipItem(xi.slot.AMMO)
    end

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
    xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.ENCUMBRANCE_II, math.random(1, 4), 0, duration)

    return dmg
end)

return m
