-----------------------------------
-- Proboscis Shower
-- Description: Restores HP.
-- Copied from Healing Breeze: needs retail calculations
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------
local m = Module:new("mobskill_proboscis_shower")

xi.module.ensureTable("xi.actions.mobskills.proboscis_shower")

m:addOverride("xi.actions.mobskills.proboscis_shower.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.proboscis_shower.onMobWeaponSkill", function(target, mob, skill)
    local potency = skill:getParam()

    if potency == 0 then
        potency = 13
    end

    potency = potency - math.random(0, potency / 4)

    skill:setMsg(xi.msg.basic.SELF_HEAL)

    return xi.mobskills.mobHealMove(mob, mob:getMaxHP() * potency / 100)
end)

return m
