-----------------------------------
-- Spell: Plenilune Embrace
-- Restores target party member's HP and enhances attack and magic attack..
-- Shamelessly stolen from http://members.shaw.ca/pizza_steve/cure/Cure_Calculator.html
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_plenilune_embrace_up')
local path = "xi.actions.mobskills.plenilune_embrace_up"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local duration = 90
    local attBoost = 1
    local magAttBoost = 1
    local potency = 0.33
    local moonPhase = VanadielMoonPhase()
    if moonPhase <= 5 then
        magAttBoost = 15
        attBoost = 1
        potency = 0.33
    elseif moonPhase <= 25 then
        magAttBoost = 12
        attBoost = 3
        potency = 0.3
    elseif moonPhase <= 40 then
        magAttBoost = 10
        attBoost = 5
        potency = 0.28
    elseif moonPhase <= 60 then
        magAttBoost = 7
        attBoost = 7
        potency = 0.25
    elseif moonPhase <= 75 then
        magAttBoost = 5
        attBoost = 10
        potency = 0.28
    elseif moonPhase <= 90 then
        magAttBoost = 3
        attBoost = 12
        potency = 0.3
    elseif moonPhase <= 100 then
        magAttBoost = 1
        attBoost = 15
        potency = 0.33
    end

    xi.mobskills.mobBuffMove(mob, xi.effect.ATTACK_BOOST, attBoost, 0, duration)
    xi.mobskills.mobBuffMove(mob, xi.effect.MAGIC_ATK_BOOST, magAttBoost, 0, duration)
    skill:setMsg(xi.msg.basic.SELF_HEAL)

    return xi.mobskills.mobHealMove(mob, mob:getMaxHP() * potency)
end)

return m
