require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/actions/mobskills/bomb_toss_suicide")
require("scripts/actions/mobskills/final_sting")
require("scripts/actions/mobskills/self-destruct")
require("scripts/actions/mobskills/hypothermal_combustion")
-----------------------------------
local m = Module:new("mob_suicide")

local settings =
{
    ["bomb_toss_suicide"]      =
    {
        percent   = 50,
        notorious = true,
    },

    ["final_sting"]            =
    {
        percent   = 25,
    },

    ["self-destruct"]          =
    {
        percent   = 50,
        notorious = true,
    },

    ["hypothermal_combustion"] =
    {
        percent   = 50,
        notorious = true,
    },

    ["nocturnal_combustion"]  =
    {
        percent   = 50,
        notorious = true,
    },
}

for skillName, skillInfo in pairs(settings) do
    local path = fmt("xi.actions.mobskills.{}.onMobSkillCheck", skillName)

    m:addOverride(path, function(target, mob, skill)
        if mob == nil then
            return 0
        end

        -- Ignore module if mob is NM and notorious setting is on, or mob is inside dynamis
        if
            (skillInfo.notorious and mob:isMobType(xi.mobType.NOTORIOUS)) or
            mob:isInDynamis()
        then
            return 1
        end

        if mob:getHPP() > skillInfo.percent then
            return 1
        else
            return 0
        end
    end)
end


return m
