-----------------------------------
--  Meteor
--
--  Description: Hardcore non-elemental damage
--  Type: Magical
--  Explanation: This override is required in order to get KS99 Horns of War working.
--  The code for Chlevnik was borrowed from AirSkyBoat, and would error out without this.
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
local m = Module:new("meteor")

xi.module.ensureTable("xi.actions.mobskills.meteor")

m:addOverride("xi.actions.mobskills.meteor.onMobWeaponSkill", function(target, mob, skill)
    local damage = 14 + mob:getMainLvl() * 30
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, damage, xi.element.NONE, 1, xi.mobskills.magicalTpBonus.PDIF_BONUS, 0, 0, 1, 1, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.NONE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.NONE)
    return dmg
end)

return m
