-----------------------------------
--  Megaflare
--  Family: Bahamut
--  Description: Deals heavy Fire damage to enemies within a fan-shaped area.
--  Type: Magical
--  Utsusemi/Blink absorb: Wipes shadows
--  Range:
--  Notes: Used by Bahamut every 10% of its HP (except at 10%), but can use at will when under 10%.
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_megaflare')

local modulePath = 'xi.actions.mobskills.megaflare'

xi.module.ensureTable(modulePath)

m:addOverride(modulePath .. '.onMobWeaponSkill', function(target, mob, skill)
    if mob:getID() == 16896157 then
        local megaFlareCount = mob:getLocalVar('megaFlareCount')
        mob:setLocalVar('megaFlareCount', megaFlareCount + 1)
        mob:setLocalVar('FlareWait', 0) -- reset the variables for Megaflare.
        mob:setLocalVar('tauntShown', 0)
        mob:setMobAbilityEnabled(true) -- re-enable the other actions on success
        mob:setMagicCastingEnabled(true)
        mob:setAutoAttackEnabled(true)

        if bit.band(mob:getBehaviour(), xi.behavior.NO_TURN) == 0 then -- re-enable noturn
            mob:setBehaviour(bit.bor(mob:getBehaviour(), xi.behavior.NO_TURN))
        end

        local dmgmod = 1
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 10, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
        return dmg
    else
        super(target, mob, skill)
    end
end)

return m
