-----------------------------------
-- Reduces AoE mobskills below level 30
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
local m = Module:new("lower_level_aoe")

m:addOverride("xi.actions.mobskills.battle_dance.onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.0

    if mob:getMainLvl() < 30 then
        dmgmod = 1.0
    end

    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, xi.mobskills.shadowBehavior.NUMSHADOWS_3)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.DEX_DOWN, 10, 3, 120)

    return dmg
end)

m:addOverride("xi.actions.mobskills.sweep.onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.0

    if mob:getMainLvl() < 30 then
        dmgmod = 1.0
    end

    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, xi.mobskills.shadowBehavior.NUMSHADOWS_3)

    xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.STUN, 1, 0, 4)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)

    return dmg
end)

m:addOverride("xi.actions.mobskills.grand_slam.onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.0

    if mob:getMainLvl() < 40 then
        dmgmod = 1.0
    end

    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, xi.mobskills.shadowBehavior.NUMSHADOWS_3)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

    return dmg
end)

return m
