---------------------------------------------
-- Horrible Roar
--
-- Description: Dispels four effects from targets in an area of effect.
-- Type: Enfeebling
-- Utsusemi/Blink absorb: Wipes Shadows
-- Range: 25' radial
-- Notes: Used by Bahamut in Wyrmking Descends
---------------------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------
local m = Module:new("mobskill_horribe_roar")

xi.module.ensureTable("xi.actions.mobskills.horrible_roar")

m:addOverride("xi.actions.mobskills.horrible_roar.onMobWeaponSkill", function(target, mob, skill)
    local count = 0

    for i = 1, 4 do
        local dispel = target:dispelStatusEffect()
        if dispel ~= xi.effect.NONE then
            count = count + 1
        end
    end

    if count > 0 then
        skill:setMsg(xi.msg.basic.DISAPPEAR_NUM)
    else
        skill:setMsg(xi.msg.basic.SKILL_NO_EFFECT) -- no effect
    end

    return count
end)

m:addOverride("xi.actions.mobskills.horrible_roar.onMobSkillCheck", function(target, mob, skill)
    if mob:getID() == 16896156 then
        return 1
    else
        return 0
    end
end)

return m
