-----------------------------------
-- Glutinous Dart
-- Damage Varies With TP.
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_glutinous_dart')
local path = "xi.actions.mobskills.glutinous_dart"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.6
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, info.hitslanded)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)
    xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BIND, 1, 0, 30)
    return dmg
end)

return m
