-----------------------------------
-- Gallu Mobskills
-----------------------------------
require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("mobskills_gallu")

local skills =
{
    ["bolt_of_perdition"] =
    {
        element = xi.element.THUNDER,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.AMNESIA,  1, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SHOCK,   30, 3, 30)

            local dmgmod = 1.6
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)
            return dmg
        end,
    },

    ["crippling_rime"] = {
        element = xi.element.ICE,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.STR_DOWN, 20, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.DEX_DOWN, 20, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.VIT_DOWN, 20, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.AGI_DOWN, 20, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.INT_DOWN, 20, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MND_DOWN, 20, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CHR_DOWN, 20, 1, 30)

            local dmgmod = 1.8
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.ICE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.ICE)
            return dmg
        end,
    },

    ["diluvial_wakes"] =
    {
        element = xi.element.WATER,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAGIC_DEF_DOWN, 50, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.DROWN,          30, 3, 30)

            local dmgmod = 1.8
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
            return dmg
        end,
    },

    ["divesting_gale"] =
    {
        element = xi.element.WIND,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.ENCUMBRANCE_I,  1, 1, 15)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CHOKE,         30, 3, 30)

            local dmgmod = 1.6
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
            return dmg
        end,
    },

    ["kurnugi_collapse"] =
    {
        element = xi.element.EARTH,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.ACCURACY_DOWN,  50, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAGIC_ACC_DOWN, 50, 1, 30)

            local dmgmod = 1.8
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)
            return dmg
        end,
    },

    ["searing_halitus"] =
    {
        element = xi.element.FIRE,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BURN, 80, 3, 30)

            local dmgmod = 1.8
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
            return dmg
        end,
    },

    ["oblivions_mantle"] =
    {
        element = xi.element.NONE,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.WEAKNESS,   1, 1, 15)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BLINDNESS,  1, 1, 30)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BIO,       20, 1, 60)

            local dmgmod = 1.5
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
            return dmg
        end,
    },

--[[
    ["unrelenting_brand"] =
    {
        element = xi.element.NONE,
        skill   = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CURSE_II,  1, 15)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BURN,     50, 15)

            local dmgmod = 1
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
            return dmg
        end,
    },
]]
}

for skillName, skillInfo in pairs(skills) do
    local skillPath = string.format("xi.actions.mobskills.%s", skillName)
    xi.module.ensureTable(skillPath)

    m:addOverride(skillPath .. ".onMobWeaponSkill", skillInfo.skill)
    m:addOverride(skillPath .. ".onMobSkillCheck", function(target, mob, skill)
        if skillInfo.element == mob:getLocalVar("ELEMENT") then
            return 0
        else
            return 1
        end
    end)
end

return m
