-----------------------------------
-- Fomor Kings
-- Balance adjustments to mobskills for Fomor Kings
-----------------------------------
require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new('fomor_king_mobskills')

local skills =
{
    ["burning_blade"] = function(target, mob, skill)
        local dmgmod = 1

        if mob:getPool() == 4696 then  -- Lugh
            dmgmod = 2.5
        end
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.NUMSHADOWS_1)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)

        return dmg
    end,

    ["red_lotus_blade"] = function(target, mob, skill)

        if mob:getPool() == 4006 then -- Trion@QuBia_Arena only
            target:showText(mob, zones[xi.zone.QUBIA_ARENA].text.RLB_LAND)
        elseif mob:getPool() == 4249 then -- Volker@Throne_Room only
            target:showText(mob, zones[xi.zone.THRONE_ROOM].text.FEEL_MY_PAIN)
        end

        local dmgmod = 1.25

        if mob:getPool() == 4696 then  -- Lugh
            dmgmod = 2.5
        end
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 4, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, xi.mobskills.shadowBehavior.NUMSHADOWS_1)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)

        return dmg
    end,

    ["gust_slash"] = function(target, mob, skill)
        local numhits = 3
        local accmod = 1
        local dmgmod = 2

        if mob:getPool() == 6885 then  -- Ethniu
            dmgmod = 1
        end

        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.ACC_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)

        return dmg
    end,

    ["aeolian_edge"] = function(target, mob, skill)
        local numhits = 3
        local accmod  = 1
        local dmgmod  = 2

        if mob:getPool() == 6885 then  -- Ethniu
            dmgmod = 1
        end

        local info    = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.ACC_VARIES, 1, 2, 3)
        local dmg     = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)

        return dmg
    end,

    ["heavy_swing"] = function(target, mob, skill)
        local numhits = 1
        local accmod = 1
        local dmgmod = 3.5
        local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
        local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

        return dmg
    end,

    ["rock_crusher"] = function(target, mob, skill)
        local dmgmod = 1
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)

        return dmg
    end,

    ["earth_crusher"] = function(target, mob, skill)
        local dmgmod = 1
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)

        return dmg
    end,
}

for skillName, skillFunc in pairs(skills) do
    local skillPath = string.format("xi.actions.mobskills.%s", skillName)
    xi.module.ensureTable(skillPath)

    if type(skillFunc) == "table" then
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc.onMobWeaponSkill)
        m:addOverride(skillPath .. ".onMobSkillCheck",  skillFunc.onMobSkillCheck)

    else
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc)
        m:addOverride(skillPath .. ".onMobSkillCheck", function(target, mob, skill)
            return 0
        end)
    end
end

return m
