-----------------------------------
-- Fantod
-- Enhances attack and magic attack.
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_fantod')
local path = "xi.actions.mobskills.fantod"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local typeEffect1 = xi.effect.ATTACK_BOOST
    local typeEffect2 = xi.effect.MAGIC_ATK_BOOST

    xi.mobskills.mobBuffMove(mob, typeEffect1, 30, 0, 90)
    xi.mobskills.mobBuffMove(mob, typeEffect2, 30, 0, 90)
    skill:setMsg(xi.mobskills.mobBuffMove(mob, typeEffect1, 30, 0, 90))

    return typeEffect
end)

return m
