require('modules/module_utils')
----------------------------------
local ID = zones[xi.zone.MINE_SHAFT_2716]
----------------------------------
local m = Module:new('enm_pulling_the_strings')

local jobTable =
{
    [xi.job.WAR] =
    {
        modelID = 1209,
        skillList = 5049,
        ability = 1428, -- Warcry
        twoHour = 688, -- Mighty Strikes
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.MNK] =
    {
        modelID = 1210,
        skillList = 5050,
        ability = 1429, -- Counterstance
        twoHour = 690, -- Hundred Fists
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.WHM] =
    {
        modelID = 1214,
        skillList = 5051,
        ability = 0, -- None
        twoHour = 689, -- Benediction
        spellListID = 1,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -100, },
        },
    },

    [xi.job.BLM] =
    {
        modelID = 1215,
        skillList = 5051,
        ability = 0, -- None
        twoHour = 691, -- Manafont
        spellListID = 2,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -100 },
        },
    },

    [xi.job.RDM] =
    {
        modelID = 1216,
        skillList = 5053,
        ability = 0, -- None
        twoHour = 692, -- Chainspell
        spellListID = 3,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -50, },
        },
    },

    [xi.job.THF] =
    {
        modelID = 1218,
        skillList = 5054,
        ability = 0, -- None
        twoHour = 693, -- Perfect Dodge
        spellListID = 0,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -50, },
        },
    },

    [xi.job.PLD] =
    {
        modelID = 1219,
        skillList = 5053,
        ability = 1431, -- Shield Bash
        twoHour = 694, -- Incincible
        spellListID = 4,
        petID = 0,
        mods = {},
    },

    [xi.job.DRK] =
    {
        modelID = 1220,
        skillList = 5055,
        ability = 1432, -- Weapon Bash
        twoHour = 695, -- Blood Weapon
        spellListID = 5,
        petID = 0,
        mods = {},
    },

    [xi.job.BST] =
    {
        modelID = 1224,
        skillList = 5049,
        petModelID =
        {
            328, -- Lizzard
            340, -- Sheep
            376, -- Funguar
            356, -- Crab
        },
        petSkillList =
        {
            174, -- Lizzard
            226, -- Sheep
            116, -- Funguar
            372, -- Crab
        },
        ability = 1433, -- Sic
        twoHour = 740, -- Familiar
        spellListID = 0,
        petID = 1,
        mods = {},
    },

    [xi.job.BRD] =
    {
        modelID = 1227,
        skillList = 5054,
        ability = 0, -- None
        twoHour = 696, -- Soul Voice
        spellListID = 6,
        petID = 0,
        mods =
        {
            { xi.mod.ATTP, -25, },
        },
    },

    [xi.job.RNG] =
    {
        modelID = 1228,
        skillList = 5056,
        ability = 1434, -- Barrage
        twoHr = 413, -- Eagle Eye Shot
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.SAM] =
    {
        modelID = 1229,
        skillList = 5057,
        ability = 1436, -- Meditate
        twoHour = 730, -- Meikyo Shisui
        spellListID = 0,
        petID = 0,
        mods = {},
    },

    [xi.job.NIN] =
    {
        modelID = 1232,
        skillList = 5058,
        ability = 0, -- None
        twoHour = 731, -- Mjin Gakure
        spellListID = 7,
        petID = 0,
        mods = {},
    },

    [xi.job.DRG] =
    {
        modelID = 1234,
        skillList = 5059,
        ability = 1437, -- Jump
        twoHour = 732, -- Call Wyvern
        spellListID = 0,
        petID = 2,
        mods = {},
    },

    [xi.job.SMN] =
    {
        modelID = 1235,
        skillList = 5052,
        petModelID =
        {
            793, -- Ifrit
            794, -- Titan
            795, -- Leviathan
            796, -- Garuda
            797, -- Shiva
            798, -- Ramuh
            791, -- Carbuncle
        },

        petSkillList =
        {
            38, -- Ifrit
            45, -- Titan
            40, -- Leviathan
            37, -- Garuda
            44, -- Shiva
            43, -- Ramuh
            34, -- Carbuncle
        },

        ability = 1438, -- Blood Pact
        twoHour = 734, -- Astral Flow
        spellListID = 0,
        petID = 3,
        mods =
        {
            { xi.mod.ATTP, -100, },
        },
    },

    [xi.job.BLU] =
    {
        modelID = 1396,
        skillList = 5053,
        ability = 0, -- None
        spellListID = 8, -- TODO: Mimic player's set spells
        petID = 0,
        mods = {},
    },

    [xi.job.COR] =
    {
        modelID = 1397,
        skillList = 5060,
        ability = 0, -- TODO: Add rolls here
        spellListID = 0, -- ???
        petID = 0,
        mods = {},
    },

    [xi.job.PUP] =
    {
        modelID = 1398,
        skillList = 5061,
        petModelID =
        {
            { 1983, xi.job.PLD }, -- Melee Automaton
            { 1990, xi.job.RNG }, -- Ranged Automaton
            { 1994, xi.job.BLM }, -- Magic Automaton
        },
        petSkillList =
        {
            364, -- Melee Automaton
            365, -- Ranged Automaton
            366, -- Magic Automaton
        },
        petSpellListID =
        {
            0, -- Melee Automaton
            0, -- Ranged Automaton
            2, -- Magic Automaton
        },
        ability = 1995, -- Maneuvers
        spellListID = 0,
        petID = 4,
        mods = {},
    }
}

local mobSkills =
{
    'arcuballista',
    'armor_piercer',
    'avalanche_axe',
    'backhand_blow',
    'barrage',
    'blade_chi',
    'blade_ei',
    'blade_rin',
    'blade_teki',
    'blast_arrow',
    'blood_pact',
    'bone_crusher',
    'brainshaker',
    'chimera_ripper',
    'counterstance',
    'cross_reaper',
    'dark_harvest',
    'daze',
    'double_thrust',
    'dulling_arrow',
    'earth_maneuver',
    'fast_blade',
    'fire_maneuver',
    'flaming_arrow',
    'full_swing',
    'gale_axe',
    'gust_slash',
    'heavy_swing',
    'hot_shot',
    'ice_maneuver',
    'knockout',
    'leg_sweep',
    'magic_mortar',
    'marionette_dice_2hr',
    'marionette_dice_attk',
    'marionette_dice_def',
    'marionette_dice_hp',
    'marionette_dice_hp_mp',
    'marionette_dice_ja_reset',
    'marionette_dice_mp',
    'marionette_dice_special',
    'marionette_dice_tp',
    'marionette_dice_tp_player',
    'meditate',
    'mistral_axe',
    'nightmare_scythe',
    'one_inch_punch',
    'piercing_arrow',
    'piercing_shot',
    'raging_axe',
    'raging_fists',
    'rock_crusher',
    'seraph_strike',
    'shadow_of_death',
    'shark_bite',
    'shell_crusher',
    'shining_strike',
    'sic',
    'slapstick',
    'slice',
    'slugshot',
    'smash_axe',
    'sniper_shot',
    'spinning_axe',
    'starburst',
    'string_clipper',
    'sunburst',
    'tachi_enpi',
    'tachi_goten',
    'tachi_junpu',
    'tachi_kagero',
    'tachi_koki',
    'thunder_maneuver',
    'thunder_thrust',
    'viper_bite',
    'vorpal_thrust',
    'warcry',
    'wasp_sting',
    'water_maneuver',
    'weapon_bash',
    'wind_maneuver'
}

local modulePath = 'xi.actions.mobskills'

for _, skill in ipairs(mobSkills) do
    xi.module.ensureTable(fmt('{}.{}', modulePath, skill))

    if string.find(skill, 'maneuver') then
        m:addOverride(fmt(modulePath .. '.{}.onMobSkillCheck', skill), function(target, mob, skill)
            print(mob)
            print(mob:getPet())
            if not mob:getPet():isAlive() then
                return 0
            elseif GetMobByID(mob:getID() + 1):isAlive() and mob:getPool() == 1296 then
                return 0
            else
                return 1
            end
        end)
    else
        m:addOverride(fmt(modulePath .. '.{}.onMobSkillCheck', skill), function(target, mob, skill)
            return 0
        end)
    end
end

m:addOverride(modulePath .. '.arcuballista.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.PIERCING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.armor_piercer.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.0
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.PIERCING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.avalanche_axe.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.1
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.backhand_blow.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.HTH,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.HTH)
    return dmg
end)

m:addOverride(modulePath .. '.barrage.onMobWeaponSkill', function(target, mob, skill)
    mob:addStatusEffect(xi.effect.BARRAGE, 0, 0, 60)
    return 0
end)

m:addOverride(modulePath .. '.blade_chi.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)
    return dmg
end)

m:addOverride(modulePath .. '.blade_ei.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
    return dmg
end)

m:addOverride(modulePath .. '.blade_rin.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.blade_teki.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.WATER, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WATER, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WATER)
    return dmg
end)

m:addOverride(modulePath .. '.blast_arrow.onMobWeaponSkill', function(target, mob, skill)
    -- TODO: Accuracy varies with TP
    local numhits = 2
    local accmod = 1.0
    local dmgmod = 2.0
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.ACC_VARIES)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.RANGED, xi.damageType.PIERCING, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.blood_pact.onMobWeaponSkill', function(target, mob, skill)
    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+3)
        pet:setTP(3000)
        pet:setMobMod(xi.mobMod.SKILL_LIST, jobTable[mob:getMainJob()].petSkillList[mob:getLocalVar("petModel")])
        mob:timer(1, function(mobArg)
            pet:setMobMod(xi.mobMod.SKILL_LIST, 0)
        end)
    else
        mob:getPet():setTP(3000)
    end

    skill:setMsg(xi.msg.basic.NONE)

    return 0
end)

m:addOverride(modulePath .. '.bone_crusher.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 3
    local accmod = 1
    local dmgmod = 1.5
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.MELEE, xi.damageType.SLASHING,info.hitslanded)

    target:addStatusEffect(xi.effect.STUN, 1, 0, 3)
    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.brainshaker.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.5
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.BLUNT,info.hitslanded)

    target:addStatusEffect(xi.effect.STUN, 1, 0, 3)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
    return dmg
end)

m:addOverride(modulePath .. '.chimera_ripper.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.MELEE, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.counterstance.onMobWeaponSkill', function(target, mob, skill)
    local typeEffect = xi.effect.COUNTERSTANCE
    local power = 20

    skill:setMsg(xi.mobskills.mobBuffMove(target, typeEffect, power, 3, 420))
    return typeEffect
end)

m:addOverride(modulePath .. '.cross_reaper.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 2.1
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.dark_harvest.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
    return dmg
end)

m:addOverride(modulePath .. '.daze.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.PIERCING,info.hitslanded)

    target:addStatusEffect(xi.effect.STUN, 1, 0, 3)
    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.double_thrust.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 1.2
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.PIERCING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.dulling_arrow.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.0
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1.1, 1.2, 1.3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.RANGED, xi.damageType.PIERCING, info.hitslanded)

    if math.random(1, 100) < skill:getTP() / 3 then
        target:addStatusEffect(xi.effect.INT_DOWN, 10, 0, 120)
    end

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.earth_maneuver.onMobWeaponSkill', function(target, mob, skill)
    local power = 10
    local duration = 60
    local typeEffect = xi.effect.EARTH_MANEUVER

    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+1)
        pet:addStatusEffect(typeEffect, power, 0, duration)
    else
        mob:getPet():addStatusEffect(typeEffect, power, 0, duration)
    end

    return 1
end)

m:addOverride(modulePath .. '.fast_blade.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 1.6
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.fire_maneuver.onMobWeaponSkill', function(target, mob, skill)
    local power = 10
    local duration = 60
    local typeEffect = xi.effect.FIRE_MANEUVER

    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+1)
        pet:addStatusEffect(typeEffect, power, 0, duration)
    else
        mob:getPet():addStatusEffect(typeEffect, power, 0, duration)
    end

    return 1
end)

m:addOverride(modulePath .. '.flaming_arrow.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
    return dmg
end)

m:addOverride(modulePath .. '.full_swing.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.7
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.BLUNT,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
    return dmg
end)

m:addOverride(modulePath .. '.gale_axe.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, info.hitslanded)

    target:addStatusEffect(xi.effect.CHOKE, 1, 0, 120)
    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
    return dmg
end)

m:addOverride(modulePath .. '.heavy_swing.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.6
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.BLUNT,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
    return dmg
end)

m:addOverride(modulePath .. '.hot_shot.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
    return dmg
end)

m:addOverride(modulePath .. '.ice_maneuver.onMobWeaponSkill', function(target, mob, skill)
    local power = 10
    local duration = 60
    local typeEffect = xi.effect.ICE_MANEUVER

    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+1)
        pet:addStatusEffect(typeEffect, power, 0, duration)
    else
        mob:getPet():addStatusEffect(typeEffect, power, 0, duration)
    end

    return 1
end)

m:addOverride(modulePath .. '.knockout.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.PIERCING,info.hitslanded)

    target:addStatusEffect(xi.effect.EVASION_DOWN, 15, 0, 120)
    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.leg_sweep.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.BLUNT,info.hitslanded)

    target:addStatusEffect(xi.effect.STUN, 1, 0, 3)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
    return dmg
end)

m:addOverride(modulePath .. '.magic_mortar.onMobWeaponSkill', function(target, mob, skill)
    local hpdmgMod = math.floor(mob:getMaxHP() * (math.floor(0.016 * mob:getTP()) + 16) / 256)

    target:takeDamage(hpdmgMod, mob, xi.attackType.BREATH, xi.damageType.ELEMENTAL)
    return hpdmgMod
end)

m:addOverride(modulePath .. '.marionette_dice_2hr.onMobWeaponSkill', function(target, mob, skill)
    local ability = jobTable[target:getMainJob()].twoHour

    if ability > 0 then
        mob:timer(5000, function(mobArg)
            target:useMobAbility(ability)
            mobArg:messageText(mobArg, ID.text.NOT_YOUR_LUCKY_DAY)
        end)
    end

    skill:setMsg(xi.msg.basic.NONE)
    return 0
end)

m:addOverride(modulePath .. '.marionette_dice_attk.onMobWeaponSkill', function(target, mob, skill)
    local power = 15
    local duration = 25
    local typeEffect = xi.effect.ATTACK_BOOST

    mob:timer(5000, function(mobArg)
        target:addStatusEffect(typeEffect, power, 0, duration)
    end)

    skill:setMsg(xi.msg.basic.SKILL_GAIN_EFFECT)
    return typeEffect
end)

m:addOverride(modulePath .. '.marionette_dice_def.onMobWeaponSkill', function(target, mob, skill)
    local power = 15
    local duration = 25
    local typeEffect = xi.effect.DEFENSE_BOOST

    mob:timer(5000, function(mobArg)
        target:addStatusEffect(typeEffect, power, 0, duration)
    end)

    skill:setMsg(xi.msg.basic.SKILL_GAIN_EFFECT)
    return typeEffect
end)

m:addOverride(modulePath .. '.marionette_dice_hp.onMobWeaponSkill', function(target, mob, skill)
    local amount = 150

    mob:timer(5000, function(mobArg)
        target:addHP(amount)
        target:wakeUp()
    end)

    skill:setMsg(xi.msg.basic.SKILL_RECOVERS_HP)
    return amount
end)

m:addOverride(modulePath .. '.marionette_dice_hp_mp.onMobWeaponSkill', function(target, mob, skill)
    local amount = 150

    mob:timer(5000, function(mobArg)
        target:addHP(amount)
        target:addMP(amount)
        target:wakeUp()
    end)

    skill:setMsg(xi.msg.basic.RECOVERS_HP_AND_MP)
    return amount
end)

m:addOverride(modulePath .. '.marionette_dice_ja_reset.onMobWeaponSkill', function(target, mob, skill)
    mob:timer(5000, function(mobArg)
        mobArg:showText(mobArg, ID.text.NOT_HOW)
        target:resetRecasts()
    end)

    skill:setMsg(xi.msg.basic.ABILITIES_RECHARGED)
    return 0
end)

m:addOverride(modulePath .. '.marionette_dice_mp.onMobWeaponSkill', function(target, mob, skill)
    local amount = 150

    mob:timer(5000, function(mobArg)
        target:addMP(amount)
    end)

    skill:setMsg(xi.msg.basic.SKILL_RECOVERS_MP)
    return amount
end)

m:addOverride(modulePath .. '.marionette_dice_special.onMobWeaponSkill', function(target, mob, skill)
    local ability = jobTable[target:getMainJob()].ability
    local spells = jobTable[target:getMainJob()].spellListID

    -- Fantoccini can use abilities and spells
    -- TODO: Fix mobMod SPELL_LIST
    mob:timer(5000, function(mobArg)
        mobArg:messageText(mobArg, ID.text.GO_GO)

        if ability > 0 and spells > 0 then
            if math.random() > 0.5 then
                target:useMobAbility(ability)
            else
                target:setSpellList(spells)
            end
        elseif ability > 0 and spells == 0 then
            target:useMobAbility(ability)
        else
            target:setSpellList(spells)
        end

        mobArg:timer(1000, function(mobArg1)
            target:setSpellList(0)
        end)
    end)

    skill:setMsg(xi.msg.basic.NONE)
    return 0
end)

m:addOverride(modulePath .. '.marionette_dice_tp.onMobWeaponSkill', function(target, mob, skill)
    -- Force Fantoccini to use an ability
    local skillList = jobTable[target:getLocalVar("job")].skillList
    target:setTP(3000)

    mob:timer(5000, function(mobArg)
        mobArg:showText(mobArg, ID.text.HA_HA)
        target:setMobMod(xi.mobMod.SKILL_LIST, skillList)

        mobArg:timer(1000, function(mobArg1)
            target:setMobMod(xi.mobMod.SKILL_LIST, 0)
        end)
    end)

    skill:setMsg(xi.msg.basic.TP_INCREASE)
    return target:getTP()
end)

m:addOverride(modulePath .. '.marionette_dice_tp_player.onMobWeaponSkill', function(target, mob, skill)
    mob:timer(5000, function(mobArg)
        target:setTP(target:getTP() + math.random(50, 1000))
    end)

    return target:getTP()
end)

m:addOverride(modulePath .. '.meditate.onMobWeaponSkill', function(target, mob, skill)
    local typeEffect = xi.effect.MEDITATE
    local duration = 15
    local power = 20

    mob:addStatusEffectEx(typeEffect, 0, power, 3, duration)
end)

m:addOverride(modulePath .. '.mistral_axe.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.5
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.nightmare_scythe.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:addStatusEffect(xi.effect.BLINDNESS, 20, 0, 120)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.one_inch_punch.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.2
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.HTH,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.HTH)
    return dmg
end)

m:addOverride(modulePath .. '.piercing_arrow.onMobWeaponSkill', function(target, mob, skill)
    -- TODO: ignore DEF based on TP
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.PIERCING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.piercing_shot.onMobWeaponSkill', function(target, mob, skill)
    -- TODO: ignore DEF based on TP
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.PIERCING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.raging_axe.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 1.5
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:addStatusEffect(xi.effect.STUN, 1, 0, 3)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.raging_fists.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 5
    local accmod = 1
    local dmgmod = 1.1
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.HTH,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.HTH)
    return dmg
end)

m:addOverride(modulePath .. '.rock_crusher.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.5
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)
    return dmg
end)

m:addOverride(modulePath .. '.seraph_strike.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.6
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.LIGHT, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.LIGHT, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.LIGHT)
    return dmg
end)

m:addOverride(modulePath .. '.shadow_of_death.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
    return dmg
end)

m:addOverride(modulePath .. '.shark_bite.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 2.2
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.HTH,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.shell_crusher.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.7
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.BLUNT,info.hitslanded)

    target:addStatusEffect(xi.effect.DEFENSE_DOWN, 15, 0, 120)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
    return dmg
end)

m:addOverride(modulePath .. '.shining_strike.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.7
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.LIGHT, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.LIGHT, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.LIGHT)
    return dmg
end)

m:addOverride(modulePath .. '.sic.onMobWeaponSkill', function(target, mob, skill)
    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+1) -- Fantoccini's monster
        pet:setTP(3000)
        pet:setMobMod(xi.mobMod.SKILL_LIST, jobTable[mob:getMainJob()].petSkillList)
        mob:timer(5000, function(mobArg)
            pet:setMobMod(xi.mobMod.SKILL_LIST, 0)
        end)
    else
        mob:getPet():setTP(3000)
    end

    skill:setMsg(xi.msg.basic.NONE)
    return 0
end)

m:addOverride(modulePath .. '.slapstick.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 3
    local accmod = 1
    local dmgmod = 1.2
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.RANGED, xi.damageType.PIERCING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.slice.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.slugshot.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 0.8
    local dmgmod = 4.0
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.ACC_VARIES, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.RANGED, xi.damageType.PIERCING, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.smash_axe.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:addStatusEffect(xi.effect.STUN, 1, 0, 3)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.sniper_shot.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.8
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, 1.1, 1.2, 1.3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.RANGED, xi.damageType.PIERCING, info.hitslanded)

    if (math.random(1, 100) < skill:getTP()/3) then
        target:addStatusEffect(xi.effect.INT_DOWN, 10, 0, 120)
    end

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.spinning_axe.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.9
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.starburst.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local attkType = xi.damageType.DARK
    local element = xi.element.DARK

    if math.random() > 0.5 then
        attkType = xi.damageType.LIGHT
        element = xi.element.DARK
    end

    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, element, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, attkType, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, attkType)
    return dmg
end)

m:addOverride(modulePath .. '.string_clipper.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 1.5
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.MELEE, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.RANGED, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.sunburst.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local attkType = xi.damageType.DARK
    local element = xi.element.DARK

    if math.random() > 0.5 then
        attkType = xi.damageType.LIGHT
        element = xi.element.DARK
    end

    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, element, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, attkType, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, attkType)
    return dmg
end)

m:addOverride(modulePath .. '.tachi_enpi.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 1.5
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.SLASHING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

m:addOverride(modulePath .. '.tachi_goten.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.LIGHT, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.LIGHTNING, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.LIGHTNING)
    return dmg
end)

m:addOverride(modulePath .. '.tachi_junpu.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 2
    local accmod = 1
    local dmgmod = 1.6
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.ACC_VARIES, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
    return dmg
end)

m:addOverride(modulePath .. '.tachi_kagero.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.FIRE, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.FIRE, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.FIRE)
    return dmg
end)

m:addOverride(modulePath .. '.tachi_koki.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.8
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.LIGHT, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.LIGHT, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.LIGHT)
    return dmg
end)

m:addOverride(modulePath .. '.thunder_maneuver.onMobWeaponSkill', function(target, mob, skill)
    local power = 10
    local duration = 60
    local typeEffect = xi.effect.THUNDER_MANEUVER

    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+1)
        pet:addStatusEffect(typeEffect, power, 0, duration)
    else
        mob:getPet():addStatusEffect(typeEffect, power, 0, duration)
    end

    return 1
end)

m:addOverride(modulePath .. '.thunder_thrust.onMobWeaponSkill', function(target, mob, skill)
    local dmgmod = 1.7
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*3, xi.element.THUNDER, dmgmod, xi.mobskills.magicalTpBonus.DMG_BONUS, 1)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.THUNDER, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.THUNDER)
    return dmg
end)

m:addOverride(modulePath .. '.viper_bite.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.HTH,info.hitslanded)

    target:addStatusEffect(xi.effect.POISON, 3, 0, 60)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)

    return dmg
end)

m:addOverride(modulePath .. '.vorpal_thrust.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 2.1
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.PIERCING,info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)
    return dmg
end)

m:addOverride(modulePath .. '.warcry.onMobWeaponSkill', function(target, mob, skill)
    local power = math.floor((mob:getMainLvl()/4)+4.75)/256
    local typeEffect = xi.effect.WARCRY
    local duration = 30

    skill:setMsg(xi.mobskills.mobBuffMove(target, typeEffect, power, 3, duration))
    return typeEffect
end)

m:addOverride(modulePath .. '.wasp_sting.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1.5
    local info = xi.mobskills.mobPhysicalMove(mob,target,skill,numhits,accmod,dmgmod,xi.mobskills.physicalTpBonus.DMG_VARIES,2.5,2.75,3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg,mob,skill,target, xi.attackType.PHYSICAL, xi.damageType.PIERCING,info.hitslanded)

    target:addStatusEffect(xi.effect.POISON, 3, 0, 60)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)

    return dmg
end)

m:addOverride(modulePath .. '.water_maneuver.onMobWeaponSkill', function(target, mob, skill)
    local power = 10
    local duration = 60
    local typeEffect = xi.effect.WATER_MANEUVER

    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+1)
        pet:addStatusEffect(typeEffect, power, 0, duration)
    else
        mob:getPet():addStatusEffect(typeEffect, power, 0, duration)
    end

    return 1
end)

m:addOverride(modulePath .. '.weapon_bash.onMobWeaponSkill', function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 0.8
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 2, 2, 2)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, info.hitslanded)

    xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.STUN, 1, 0, 5)
    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)
    return dmg
end)

m:addOverride(modulePath .. '.wind_maneuver.onMobWeaponSkill', function(target, mob, skill)
    local power = 10
    local duration = 60
    local typeEffect = xi.effect.WIND_MANEUVER

    -- Fantoccini (ENM: Pulling the Strings)
    if mob:getPool() == 1296 then
        local pet = GetMobByID(mob:getID()+1)
        pet:addStatusEffect(typeEffect, power, 0, duration)
    else
        mob:getPet():addStatusEffect(typeEffect, power, 0, duration)
    end

    return 1
end)

return m
