-----------------------------------
-- Spell: Carcharian Verve
-- Enhances attack, magic attack and magic defense.
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_carcharian_verve')
local path = "xi.actions.mobskills.carcharian_verve"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local typeEffect1 = xi.effect.MAGIC_ATK_BOOST
    local typeEffect2 = xi.effect.ATTACK_BOOST
    local typeEffect3 = xi.effect.MAGIC_DEF_BOOST

    skill:setMsg(xi.mobskills.mobBuffMove(mob, typeEffect1, 20, 0, 60))
    xi.mobskills.mobBuffMove(mob, typeEffect2, 20, 0, 60)
    xi.mobskills.mobBuffMove(mob, typeEffect3, 20, 0, 60)
    
    return typeEffect1
end)

return m
