-----------------------------------
--  Bored to Tears
--  Trust: Ullegore
--  Type: Slow effect
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
local m = Module:new("mobskill_bored_to_tears")

xi.module.ensureTable("xi.actions.mobskills.bored_to_tears")

m:addOverride("xi.actions.mobskills.bored_to_tears.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.bored_to_tears.onMobWeaponSkill", function(target, mob, skill)
    local typeEffect = xi.effect.SLOW
    local power      = 1500 -- 15%
    local duration   = math.random(60, 180)

    target:addStatusEffect(typeEffect, power, 0, duration)
    mob:messageBasic(763, skill:getID(), 0, target)
    -- 763 = <mob> uses <skillID>. <target> has grown noticeably bored.

    return typeEffect
end)

return m
