-----------------------------------
-- Bionic Boost
-- Description:
-- Gives the user the effect of counterstance
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('bionic_boost')

xi.module.ensureTable('xi.actions.mobskills.bionic_boost')

m:addOverride('xi.actions.mobskills.bionic_boost.onMobSkillCheck', function(target, mob, skill)
    return 0
end)

m:addOverride('xi.actions.mobskills.bionic_boost.onMobWeaponSkill', function(target, mob, skill)
    local typeEffect = xi.effect.COUNTERSTANCE

    skill:setMsg(xi.mobskills.mobBuffMove(mob, typeEffect, 1, 0, 30))

    return typeEffect
end)

return m
