-----------------------------------
-- Barrier Tusk
-- Enhances defense and magic defense
-- Marids will only use Barrier Tusk if at least one of their tusks remain unbroken
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_barrier_tusk')
local path = "xi.actions.mobskills.barrier_tusk"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    if mob:getAnimationSub() < 2 then
        return 0
    end
    
    return 1
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local typeEffect = xi.effect.DEFENSE_BOOST

    xi.mobskills.mobBuffMove(mob, typeEffect, 30, 0, 90)
    skill:setMsg(xi.mobskills.mobBuffMove(mob, typeEffect, 30, 0, 90))

    return typeEffect
end)

return m
