-----------------------------------
-- Bai Wing
--
-- Description: A dust storm deals Earth damage to enemies within a very wide area of effect. Additional effect: Slow
-- Type: Magical
-- Utsusemi/Blink absorb: Wipes shadows
-- Range: 30' radial.
-- Notes: Used only by Ouryu and Cuelebre while flying.
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------

local m = Module:new("bai_wing")

xi.module.ensureTable("xi.actions.mobskills.bai_wing")

m:addOverride("xi.actions.mobskills.bai_wing.onMobSkillCheck", function(target, mob, skill)
    if mob:getAnimationSub() ~= 1 then
        return 1
    end
    return 0
end)

m:addOverride("xi.actions.mobskills.bai_wing.onMobWeaponSkill", function(target, mob, skill)
    -- CoP 4-2 version is level capped and shouldn't have custom mods applied
    if mob:getZoneID() == xi.zone.MONARCH_LINN then
        super(target, mob, skill)
    else
        local dmgmod = 1
        if mob:getLocalVar("savageDmgMultipliers") == 1 then
            dmgmod = 2
        else
            dmgmod = 3
        end

        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 5, xi.element.EARTH, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.EARTH, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SLOW, 6000, 0, 120)

        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.EARTH)
        return dmg
    end
end)

return m
