---------------------------------------------
--  Trust AAEV mobskills
---------------------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------
local m = Module:new("aaev_mobskills")
---------------------------------------------
xi.module.ensureTable("xi.actions.mobskills.chant_du_cygne")
xi.module.ensureTable("xi.actions.mobskills.arrogance_incarnate")
---------------------------------------------

-- Vorpal Blade Logic (Using old CXI logic)
m:addOverride("xi.actions.mobskills.chant_du_cygne.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.impulsion.onMobWeaponSkill", function(target, mob, skill)
    local numhits = 3
    local accmod  = 1
    local dmgmod  = 1.5
    local info    = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.CRIT_VARIES, 1.1, 1.2, 1.3)
    local dmg     = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    return dmg
end)

-- Spirits Within Logic (Using old CXI logic)
m:addOverride("xi.actions.mobskills.arrogance_incarnate.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.arrogance_incarnate.onMobWeaponSkill", function(target, mob, skill)
    local tp  = skill:getTP()
    local hp  = mob:getHP()
    local dmg = 0

    if (tp <= 2000) then
        dmg = math.floor(hp * (math.floor(0.016 * tp) + 16) / 256)
    else
        dmg = math.floor(hp * (math.floor(0.072 * tp) - 96) / 256)
    end

    dmg = dmg * 2.5

    dmg = target:breathDmgTaken(dmg)

    dmg = dmg - target:getMod(xi.mod.PHALANX)

    if (dmg < 0) then
        return 0
    end

    dmg = utils.stoneskin(target, dmg)

    if (dmg > 0) then
        target:wakeUp()
        target:updateEnmityFromDamage(mob, dmg)
    end

    target:takeDamage(dmg, mob, xi.attackType.BREATH, xi.damageType.ELEMENTAL)
    return dmg
end)

return m
