-----------------------------------
-- Area: Arrapago Reef
--   NM: Zareehkl the Jubilant
-----------------------------------
require('modules/module_utils')
require('scripts/mixins/families/qutrub')
-----------------------------------
local m = Module:new('znm_zareehkl_the_jubilant')

local modulePath = 'xi.zones.Arrapago_Reef.mobs.Zareehkl_the_Jubilant'

xi.module.ensureTable(modulePath)

m:addOverride(modulePath .. '.onMobInitialize', function(mob)
    g_mixins.families.qutrub(mob)
    mob:addMod(xi.mod.MDEF, 150)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:setMod(xi.mod.STUNRES, 50)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addMod(xi.mod.SLEEPRES, 10000)
    mob:addImmunity(xi.immunity.BIND)
    mob:addMod(xi.mod.ATT, 25)
    mob:addMod(xi.mod.MDEF, 50)
    mob:addMod(xi.mod.DEF, 25)
    mob:addMod(xi.mod.MAIN_DMG_RATING, 10)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 5)
    mob:addStatusEffect(xi.effect.REGAIN, 2, 3, 0)
    mob:addStatusEffect(xi.effect.REGEN, 5, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 10, 3, 0)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.EARTH_MEVA, 25)
    mob:setMod(xi.mod.DARK_MEVA, 25)
    mob:setMod(xi.mod.LIGHT_MEVA, 25)
    mob:setMod(xi.mod.FIRE_MEVA, 25)
    mob:setMod(xi.mod.WATER_MEVA, 25)
    mob:setMod(xi.mod.THUNDER_MEVA, 25)
    mob:setMod(xi.mod.ICE_MEVA, 25)
    mob:setMod(xi.mod.WIND_MEVA, 25)
    mob:setMod(xi.mod.EARTH_SDT, 25)
    mob:setMod(xi.mod.DARK_SDT, 25)
    mob:setMod(xi.mod.LIGHT_SDT, 25)
    mob:setMod(xi.mod.FIRE_SDT, 25)
    mob:setMod(xi.mod.WATER_SDT, 25)
    mob:setMod(xi.mod.THUNDER_SDT, 25)
    mob:setMod(xi.mod.ICE_SDT, 25)
    mob:setMod(xi.mod.WIND_SDT, 25)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:setMod(xi.mod.FASTCAST, 10)
    mob:addMod(xi.mod.MOVE_SPEED_STACKABLE, 12)
    mob:setAnimationSub(0)
    mob:setLocalVar('qutrubBreakChance', 5) -- Wiki implies its weapon is harder to break
end)

return m
