-----------------------------------
-- CatsEyeXI Sky 2.0
-- Area: Escha Ru'Aun Gardens
--   NM: Suzaku pet
-----------------------------------
local ID = require("scripts/zones/Escha_RuAun/IDs")
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/globals/mobs")
-----------------------------------
local m = Module:new("sky_2_0_suzaku_pet")

xi.module.ensureTable("xi.zones.Escha_RuAun.mobs.Suzaku_Pet")

m:addOverride("xi.zones.Escha_RuAun.mobs.Suzaku_Pet.onMobInitialize", function(mob)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Suzaku_Pet.onMobSpawn", function(mob)
    mob:setMod(xi.mod.DEF, 200)
    mob:setMod(xi.mod.EVA, 100)
    mob:setMod(xi.mod.MDEF, 100)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.BIND)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setDropID(0)
end)

-- Return the selected spell ID.
m:addOverride("xi.zones.Escha_RuAun.mobs.Suzaku_Pet.onMobMagicPrepare", function(mob, target, spellId)
    -- Suzaku uses     Burn, Fire IV, Firaga III, Flare
    -- Let's give -ga3 a higher distribution than the others.
    local rnd = math.random()

    if rnd < 0.5 then
        return 176 -- firaga 3
    elseif rnd < 0.7 then
        return 147 -- fire 4
    elseif rnd < 0.9 then
        return 204 -- flare
    else
        return 235 -- burn
    end
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Suzaku_Pet.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENFIRE)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Suzaku_Pet.onMobDeath", function(mob, player, optParams)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Suzaku_Pet.onMobDespawn", function(mob)
end)

return m
