-----------------------------------
-- CatsEyeXI Sky 2.0
-- Area: Escha Ru'Aun Gardens
--   NM: Seiryu Pet
-----------------------------------
local ID = require("scripts/zones/Escha_RuAun/IDs")
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/globals/mobs")
-----------------------------------
local m = Module:new("sky_2_0_seiryu_pet")

xi.module.ensureTable("xi.zones.Escha_RuAun.mobs.Seiryu_Pet")

m:addOverride("xi.zones.Escha_RuAun.mobs.Seiryu_Pet.onMobInitialize", function(mob)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Seiryu_Pet.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENAERO)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Seiryu_Pet.onMobSpawn", function(mob)
    mob:setMod(xi.mod.DEF, 200)
    mob:setMod(xi.mod.EVA, 100)
    mob:setMod(xi.mod.MDEF, 100)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.BIND)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setDropID(0)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Seiryu_Pet.onMobMagicPrepare", function(mob, target, spellId)
    if not mob:hasStatusEffect(xi.effect.HUNDRED_FISTS, 0) then
        local rnd = math.random()
        if rnd < 0.5 then
            return 186 -- aeroga 3
        elseif rnd < 0.7 then
            return 157 -- aero 4
        elseif rnd < 0.9 then
            return 208 -- tornado
        else
            return 237 -- choke
        end
    end
    return 0 -- Still need a return, so use 0 when not casting
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Seiryu_Pet.onMobDeath", function(mob, player, optParams)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Seiryu_Pet.onAdditionalEffect", function(mob, target, damage)
end)

return m
