-----------------------------------
-- CatsEyeXI Sky 2.0
-- Area: Escha Ru'Aun Gardens
--   NM: Kouryu
-----------------------------------
local ID = require("scripts/zones/Escha_RuAun/IDs")
require("modules/module_utils")
require("scripts/mixins/rage")
require("scripts/globals/mobs")
-----------------------------------
local m = Module:new("sky_2_0_kouryu")

xi.module.ensureTable("xi.zones.Escha_RuAun.mobs.Kouryu")

m:addOverride("xi.zones.Escha_RuAun.mobs.Kouryu.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 180)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Kouryu.onMobSpawn", function(mob)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.BIND)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:addImmunity(xi.immunity.PARALYZE)
    mob:addImmunity(xi.immunity.STUN)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addMod(xi.mod.MDEF, mob:getMod(xi.mod.MDEF) + 200)

    -- Reduce damage taken -25%
    mob:addMod(xi.mod.UDMGPHYS,   -2500)
    mob:addMod(xi.mod.UDMGRANGE,  -2500)
    mob:addMod(xi.mod.UDMGMAGIC,  -2500)
    mob:addMod(xi.mod.UDMGBREATH, -2500)

    mob:setDropID(3989)
    mob:setHP(mob:getMaxHP() / 2)
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Kouryu.onMobFight", function(mob, target)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Kouryu.onMobDespawn", function(mob)
    SetServerVariable("[SKY2]Kirin_FIGHT", 0)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Kouryu.onMobDeath", function(mob, player, optParams)
    local keyItemGiven = mob:getLocalVar("keyItemGiven")

    player:addTitle(xi.title.KIRIN_DISMANTLER)

    if keyItemGiven == 1 then
        return
    end

    local alliance = player:getAlliance()

    for _, participant in pairs(alliance) do
        local serverVar = GetServerVariable("[SKY2]Kirin_FIGHT")
        local playerVar = participant:getCharVar("[SKY2]Kirin_FIGHT")

        if serverVar == playerVar and not participant:hasKeyItem(xi.ki.KIRINS_FERVOR) then
            npcUtil.giveKeyItem(participant, xi.ki.KIRINS_FERVOR)
            participant:setCharVar("[SKY2]Kirin_FIGHT", 0)
            SetServerVariable("[SKY2]Kirin_FIGHT", 0)
            mob:setLocalVar("keyItemGiven", 1)
            break
        end
    end

    cexi.aether.rollCasket(mob, player)
end)

return m
