-----------------------------------
-- CatsEyeXI Sky 2.0
-- Area: Escha Ru'Aun Gardens
--   NM: Byakko Pet
-----------------------------------
local ID = require("scripts/zones/Escha_RuAun/IDs")
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/globals/mobs")
-----------------------------------
local m = Module:new("sky_2_0_Byakko_Pet")

xi.module.ensureTable("xi.zones.Escha_RuAun.mobs.Byakko_Pet")

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko_Pet.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko_Pet.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENLIGHT)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko_Pet.onMobSpawn", function(mob)
    mob:setMod(xi.mod.DEF, 200)
    mob:setMod(xi.mod.EVA, 100)
    mob:setMod(xi.mod.MDEF, 100)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.BIND)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setDropID(0)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko_Pet.onMobDespawn", function(mob)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko_Pet.onMobDeath", function(mob, player, optParams)
end)

return m
