-----------------------------------
-- CatsEyeXI Sky 2.0
-- Area: Escha Ru'Aun Gardens
--   NM: Byakko
-----------------------------------
local ID = require("scripts/zones/Escha_RuAun/IDs")
require("scripts/globals/mobs")
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
-----------------------------------
local m = Module:new("sky_2_0_byakko")

xi.module.ensureTable("xi.zones.Escha_RuAun.mobs.Byakko")

local despawnMobTable =
{
    17961219,
    17961220,
    17961221,
    17961222,
    17961223,
    17961224,
    17961225,
    17961226,
}

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PARALYZE)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMobMod(xi.mobMod.CHARMABLE, 0)
    mob:setMobMod(xi.mobMod.DRAW_IN, 1)
    mob:addMod(xi.mod.ACC, 100)
    mob:addMod(xi.mod.EVA, -14)
    mob:addMod(xi.mod.MAIN_DMG_RATING, 20)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 25)
    mob:setMod(xi.mod.EARTH_SDT, 250)
    mob:setMod(xi.mod.LIGHT_SDT, 200)
    mob:setMod(xi.mod.FIRE_SDT, 250)
    mob:setMod(xi.mod.WATER_SDT, 250)
    mob:setMod(xi.mod.THUNDER_SDT, 350)
    mob:setMod(xi.mod.ICE_SDT, 350)
    mob:setMod(xi.mod.WIND_SDT, 250)
    mob:setMod(xi.mod.LIGHT_ABSORB, 200)
    mob:setMod(xi.mod.UFASTCAST, 20)
    mob:addMod(xi.mod.MDEF, 20)

    -- Reduce damage taken -25%
    mob:addMod(xi.mod.UDMGPHYS,   -2500)
    mob:addMod(xi.mod.UDMGRANGE,  -2500)
    mob:addMod(xi.mod.UDMGMAGIC,  -2500)
    mob:addMod(xi.mod.UDMGBREATH, -2500)

    mob:addStatusEffect(xi.effect.REFRESH, 30, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENLIGHT)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    xi.mix.jobSpecial.config(mob, {
        between = 240, -- 4 min PD timer
        specials =
        {
            {id = xi.jsa.PERFECT_DODGE, cooldown = 0, hpp = 100},
        },
    })

    if mob:hasStatusEffect(xi.effect.SILENCE) then
        mob:useMobAbility(689) -- Benediction
    end

    mob:addListener("WEAPONSKILL_TAKE", "ATONEMENT_HATE_RESET", function(mobArg, user, wsid)
        if wsid == 45 then
            mob:resetEnmity(user)

            mob:timer(5000, function(mobArg)
                local enmityList = mobArg:getEnmityList()
                local numEntries = #enmityList

                killPlayer = utils.randomEntry(enmityList)["entity"]
                if killPlayer then
                    killPlayer:setHP(0)
                end
            end)
        end
    end)

    mob:addListener("MAGIC_TAKE", "ENFEEBLING_DEATH", function(target, caster, spell)
        if spell:getSkillType() == xi.skill.ENFEEBLING_MAGIC and spell:getID() ~= 59 then  -- Silence

            mob:timer(5000, function(mobArg)
                local enmityList = mobArg:getEnmityList()
                local numEntries = #enmityList

                killPlayer = utils.randomEntry(enmityList)["entity"]
                if killPlayer then
                    killPlayer:setHP(0)
                end
            end)
        end
    end)
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onMobFight", function(mob, target)
    local lifePercent = mob:getHPP()
    local twoHourUsed = mob:getLocalVar("twoHourUsed")

    if lifePercent <= 60 and lifePercent >= 50 and twoHourUsed == 0 then
        mob:useMobAbility(731) --MIJIN_GAKURE
        mob:setLocalVar("twoHourUsed", 1)
    end

    if lifePercent <= 30 and lifePercent >= 20 and twoHourUsed == 1 then
        mob:useMobAbility(731) --MIJIN_GAKURE
        mob:setLocalVar("twoHourUsed", 2)
    end

    if lifePercent <= 10 and lifePercent >= 5 and twoHourUsed == 2 then
        mob:useMobAbility(731) --MIJIN_GAKURE
        mob:setLocalVar("twoHourUsed", 3)
    end

    if lifePercent >= 62 and twoHourUsed >= 1 then
        mob:resetLocalVars()
    end

    if lifePercent >= 32 and twoHourUsed == 2 then
        mob:resetLocalVars()
    end

    if lifePercent >= 12 and twoHourUsed == 3 then
        mob:resetLocalVars()
    end
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onMobDisengage", function(mob, player)
    mob:resetLocalVars()
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onMobRoam", function(mob)
    mob:resetLocalVars()
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onMobDespawn", function(mob)
    for _, despawnMob in ipairs(despawnMobTable) do
        SpawnMob(despawnMob)
    end
    SetServerVariable("[SKY2]Byakko_FIGHT", 0)
    mob:removeListener("ATONEMENT_HATE_RESET")
    mob:removeListener("ENFEEBLING_DEATH")
    mob:resetLocalVars()
end)

m:addOverride("xi.zones.Escha_RuAun.mobs.Byakko.onMobDeath", function(mob, player, optParams)
    local keyItemGiven = mob:getLocalVar("keyItemGiven")

    player:addTitle(xi.title.BYAKKO_TAMER)

    if keyItemGiven == 1 then
        return
    end

    local alliance = player:getAlliance()

    for _, participant in pairs(alliance) do
        local serverVar = GetServerVariable("[SKY2]Byakko_FIGHT")
        local playerVar = participant:getCharVar("[SKY2]Byakko_FIGHT")

        if serverVar == playerVar and not participant:hasKeyItem(xi.ki.BYAKKOS_PRIDE) then
            npcUtil.giveKeyItem(participant, xi.ki.BYAKKOS_PRIDE)
            participant:setCharVar("[SKY2]Byakko_FIGHT", 0)
            SetServerVariable("[SKY2]Byakko_FIGHT", 0)
            mob:setLocalVar("keyItemGiven", 1)
            break
        end
    end

    cexi.aether.rollCasket(mob, player)
end)

return m
