---------------------------------------
-- CatsEyeXI
-- Mob: Qnzdei
---------------------------------------
require("modules/module_utils")
local ID = zones[xi.zone.THE_GARDEN_OF_RUHMET]
mixins = { require('scripts/mixins/families/zdei') }
-----------------------------------
local m = Module:new("qnzdei_nm")

local path = "xi.zones.The_Garden_of_RuHmet.mobs.Qnzdei"
xi.module.ensureTable(path)

local qnzdeiIDs = {
    ID.mob.QNZDEI_OFFSET,
    ID.mob.QNZDEI_OFFSET + 1,
    ID.mob.QNZDEI_OFFSET + 2,
    ID.mob.QNZDEI_OFFSET + 3,
}

local spinSpeeds = { 4, 8, 16, 64 }

local function doorAction(mob, idle)
    local mobID = mob:getID()

    -- Check if the mob ID is one of the first four Qn'Zdei
    for _, qnzID in ipairs(qnzdeiIDs) do
        if mobID == qnzID then
            local doorID = ID.npc.QNZDEI_DOOR_OFFSET
            local door = GetNPCByID(doorID)

            -- Perform door animation and other actions
            local doorIdle = door:getLocalVar('idle')

            if mob:getLocalVar('idle') ~= idle then
                mob:setLocalVar('idle', idle)

                if idle == 0 then
                    doorIdle = math.max(0, doorIdle - 1)
                else
                    doorIdle = math.min(doorIdle + 1, 4)
                end

                if doorIdle == 4 then
                    door:setAnimation(xi.animation.OPEN_DOOR)
                    door:setUntargetable(true)
                else
                    door:setAnimation(xi.animation.CLOSE_DOOR)
                    door:setUntargetable(false)
                end

                door:setLocalVar('idle', doorIdle)
            end
            return
        end
    end
end

m:addOverride(path .. ".onMobSpawn", function(mob)
    doorAction(mob, 1)

    -- Qn'Zdei randomly spin at speeds 4, 8, 16, 64 and can be reversed (negative)
    mob:setLocalVar('spinSpeed', utils.randomEntry(spinSpeeds))
    if math.random(1, 2) == 1 then
        mob:setLocalVar('reversed', 1)
    end
end)

m:addOverride(path .. ".onMobEngage", function(mob, target)
    doorAction(mob, 0)
end)

m:addOverride(path .. ".onPath", function(mob)
    local spawnPos = mob:getSpawnPos()
    mob:pathThrough({ spawnPos.x, spawnPos.y, spawnPos.z })
    local pos = mob:getPos()
    if spawnPos.x == pos.x and spawnPos.z == pos.z then
        doorAction(mob, 1)

        local speed = mob:getLocalVar('spinSpeed')
        if mob:getLocalVar('reversed') == 1 then
            speed = -speed
        end

        mob:setPos(spawnPos.x, spawnPos.y, spawnPos.z, mob:getRotPos() + speed)
    end
end)

m:addOverride(path .. ".onMobDeath", function(mob, player, optParams)
    doorAction(mob, 1)
end)

return m
