-----------------------------------
-- NM: Shieldtrap
-----------------------------------
require('modules/module_utils')
local ID = zones[xi.zone.RIVERNE_SITE_A01]
-----------------------------------
local m = Module:new('nm_shieldtrap')

local SHIELD_BUG = 1881
local SHIELDTRAP = 16900320
local spellLists = { 17, 13, 15, 12, 14, 16, 19, 18 }
local qmPoints   =
{
    [1]  = { 184.50, 1.00, 359.50 },
    [2]  = { 273.82, 2.62, 269.04 },
    [3]  = { 578.67, 2.99, 345.70 },
    [4]  = { 390.80, 1.83, 309.77 },
    [5]  = { 130.72, 0.53, 433.06 },
    [6]  = {   8.21, 2.36, 309.08 },
    [7]  = { -54.12, 0.40, 367.57 },
}

local function moveQM(npc)
    local currentPoint = npc:getLocalVar('currentPoint')
    local nextPoint = math.random(1, #qmPoints)

    if nextPoint == currentPoint then
        nextPoint = nextPoint + 1
        if nextPoint == 8 then
            nextPoint = 1
        end
    end

    local nextPointLoc = qmPoints[nextPoint]
    npc:setLocalVar('currentPoint', nextPoint)
    npc:setStatus(xi.status.NORMAL)
    npcUtil.queueMove(npc, nextPointLoc, 10000)
end

-- Initialize tables
xi.module.ensureTable('xi.zones.Riverne-Site_A01.mobs.Shieldtrap')
xi.module.ensureTable('xi.zones.Riverne-Site_A01.npcs.qm')
xi.module.ensureTable('xi.zones.Riverne-Site_A01.npcs.qm_shieldtrap')

-----------------------------------
-- Area: Riverne-Site #A01
--  Mob: Shieldtrap
-----------------------------------
m:addOverride('xi.zones.Riverne-Site_A01.mobs.Shieldtrap.onMobSpawn', function(mob)
    local day = VanadielDayOfTheWeek()
    mob:setLocalVar('currentDay', day)
end)

m:addOverride('xi.zones.Riverne-Site_A01.mobs.Shieldtrap.onMobFight', function(mob, target)
    -- Casts spells according to the current day of the week
    if VanadielDayOfTheWeek() ~= mob:getLocalVar('currentDay') then
        for k, v in pairs(xi.day) do
            if v == VanadielDayOfTheWeek() then
                mob:setSpellList(spellLists[k])
            end
        end
    end
end)

-----------------------------------
-- Area: Riverne-Site #A01
--  NPC: qm_shieldbug (qm)
-----------------------------------
m:addOverride('xi.zones.Riverne-Site_A01.npcs.qm.onTrigger', function(player, npc)
    npcUtil.giveItem(player, SHIELD_BUG)
end)

m:addOverride('xi.zones.Riverne-Site_A01.npcs.qm.onTimeTrigger', function(npc, triggerID)
    if os.time() > npc:getLocalVar('moveTime') then
        moveQM(npc)
        npc:setLocalVar('moveTime', os.time() + 7200)
    end
end)

-----------------------------------
-- Area: Riverne-Site #A01
--  NPC: qm_shieldtrap
-----------------------------------
m:addOverride('xi.zones.Riverne-Site_A01.npcs.qm_shieldtrap.onTrade', function(player, npc, trade)
    if npcUtil.tradeHas(trade, SHIELD_BUG) and npcUtil.popFromQM(player, npc, SHIELDTRAP) then
        player:confirmTrade()
    end
end)

m:addOverride('xi.zones.Riverne-Site_A01.npcs.qm_shieldtrap.onTrigger', function(player, npc)
    player:messageSpecial(ID.text.INSECT_WINGS)
end)

return m
