-----------------------------------
-- CatsEyeXI
-----------------------------------
require('modules/module_utils')
require('scripts/mixins/job_special')
local ID = zones[xi.zone.VUNKERL_INLET_S]
-----------------------------------
local m = Module:new('nm_pallas')

local pallasID =
{
    PALLAS      = 17117250,
    PALLAS_S_PH =
    {
        [17117241] = 17117250,
        [17117246] = 17117250,
    },
    PALLASS_TIGER = { 17117251, 17117252, 17117253 },
}

local function callTigerPet(mob, target)
    local act         = mob:getCurrentAction()
    local petsSpawned = mob:getLocalVar('petsSpawned')
    local isBusy      = false

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH
    then
        isBusy = true
    end

    if
        mob:actionQueueEmpty() and
        not isBusy
    then
        if petsSpawned ~= 1 then
            -- Begin casting animation
            mob:timer(1000, function(mobArg)
                mobArg:entityAnimationPacket('casm')
            end)

            -- End casting animation
            mob:timer(4000, function(mobArg)
                mobArg:entityAnimationPacket('shsm')

                -- If any of the pets are down, spawn them and assign enmity
                for _, tigerPet in ipairs(pallasID.PALLASS_TIGER) do
                    local petId = GetMobByID(tigerPet)

                    if not petId:isSpawned() then
                        mob:setLocalVar('petsSpawned', 1)
                        mob:setLocalVar('respawnTime', os.time() + math.random(45, 60))
                        petId:setSpawn(mob:getXPos() + math.random(1, 3), mob:getYPos(), mob:getZPos() + math.random(1, 3))

                        if target ~= nil then
                            SpawnMob(petId:getID()):updateEnmity(target)
                        else
                            petId:spawn()
                        end
                    end
                end
            end)
        end
    end
end

-----------------------------------
-- Area: Vunkerl Inlet [S]
-- Mob: Pallas
-----------------------------------
xi.module.ensureTable('xi.zones.Vunkerl_Inlet_[S].mobs.Pallas')

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallas.onMobInitialize', function(mob)
    g_mixins.job_special(mob)
end)

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallas.onMobSpawn', function(mob)
    mob:addListener('WEAPONSKILL_STATE_EXIT', 'AWAKEN_PETS', function(mobArg, skillId)
        local familiarId = 740

        if skillId == familiarId then
            for _, tigerPet in ipairs(pallasID.PALLASS_TIGER) do
                local petId = GetMobByID(tigerPet)

                if petId:isAlive() then
                    petId:delStatusEffect(xi.effect.SLEEP_I)
                    petId:delStatusEffect(xi.effect.SLEEP_II)
                    petId:delStatusEffect(xi.effect.LULLABY)
                    petId:addMod(xi.mod.SLEEPRES, 80)
                end
            end
        end
    end)
end)

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallas.onMobSpawn', function(mob)
    callTigerPet(mob)
end)

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallas.onMobEngage', function(mob, target)
    for _, tigerPet in ipairs(pallasID.PALLASS_TIGER) do
        local petId = GetMobByID(tigerPet)

        if petId:isAlive() then
            petId:updateEnmity(target)
        end
    end
end)

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallas.onMobFight', function(mob, target)
    if
        mob:getLocalVar('petsSpawned') ~= 1 and
        os.time() >= mob:getLocalVar('respawnTime')
    then
        callTigerPet(mob, target)
    end
end)

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallas.onMobDeath', function(mob, player, optParams)
    for _, tigerPet in ipairs(pallasID.PALLASS_TIGER) do
        DespawnMob(tigerPet)
    end

    xi.hunts.checkHunt(mob, player, 489)
end)

-----------------------------------
-- Area: Vunkerl Inlet [S]
--  Mob: Pallas's Tiger
-----------------------------------
xi.module.ensureTable('xi.zones.Vunkerl_Inlet_[S].mobs.Pallass_Tiger')

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallass_Tiger.onMobSpawn', function(mob)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
end)

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallass_Tiger.onAdditionalEffect', function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.PARALYZE, { duration = 60 })
end)

m:addOverride('xi.zones.Vunkerl_Inlet_[S].mobs.Pallass_Tiger.onMobDeath', function(mob, player, optParams)
    GetMobByID(pallasID.PALLAS):setLocalVar('petsSpawned', 0)
end)

-----------------------------------
-- Area: Vunkerl Inlet [S]
--  Mob: Gigas Helmsman (Placeholder)
-----------------------------------
xi.module.ensureTable('xi.zones.Vunkerl_Inlet_[S].mobs.Gigas_Helmsman')

m:addOverride("xi.zones.Vunkerl_Inlet_[S].mobs.Gigas_Helmsman.onMobDespawn", function(mob)
    local mobID = mob:getID()

    for phID, nmID in pairs(pallasID.PALLAS_S_PH) do
        if mobID == phID then
            xi.mob.phOnDespawn(mob, pallasID.PALLAS_S_PH, 5, 3600) -- 1 hour
        end
    end
end)

return m
