-----------------------------------
-- Area: Alzadaal Undersea Ruins
--  Mob: Oupire
-----------------------------------
require('scripts/globals/hunts')
require('scripts/globals/magic')
require('scripts/globals/mobs')
require('scripts/globals/npc_util')
require('modules/module_utils')
-----------------------------------
local m = Module:new('nm_oupire')

local modulePath = 'xi.zones.Alzadaal_Undersea_Ruins.mobs.Oupire'

local function changePhase(mob, phase)
    -- phase buffs are dispellable and stealable, 60m duration
    local duration = 60 * 60
    local allPhaseBuffs = {
        xi.effect.ENSTONE,
        xi.effect.ENWATER,
        xi.effect.ENAERO,
        xi.effect.ENFIRE,
        xi.effect.ENBLIZZARD,
        xi.effect.ENTHUNDER,
        xi.effect.BLAZE_SPIKES,
        xi.effect.ICE_SPIKES,
        xi.effect.SHOCK_SPIKES,
    }

    for _, effectID in ipairs(allPhaseBuffs) do
        mob:delStatusEffect(effectID)
    end

    -- Remove Defensive Buffs
    mob:setMod(xi.mod.BLINK, 0)
    mob:setMod(xi.mod.STONESKIN, 0)

    -- Remove Elemental Resistances
    mob:setMod(xi.mod.EARTH_MEVA, 128)
    mob:setMod(xi.mod.WATER_MEVA, 128)
    mob:setMod(xi.mod.WIND_MEVA, 128)
    mob:setMod(xi.mod.FIRE_MEVA, 128)
    mob:setMod(xi.mod.ICE_MEVA, 128)
    mob:setMod(xi.mod.THUNDER_MEVA, 128)

    -- Remove Status Resistances
    mob:setMod(xi.mod.BINDRES, 50)
    mob:setMod(xi.mod.PARALYZERES, 50)
    mob:setMod(xi.mod.POISONRES, 50)
    mob:setMod(xi.mod.SLOWRES, 50)
    mob:setMod(xi.mod.STUNRES, 50)

    -- Set Phase-Specific Mods
    if phase == 1 then -- Fire
        mob:setSpellList(460)
        mob:addStatusEffect(xi.effect.BLAZE_SPIKES, 10, 0, duration)
        mob:addStatusEffect(xi.effect.ENFIRE, 10, 0, 0)
        mob:setMod(xi.mod.FIRE_MEVA, 200)
    elseif phase == 2 then -- Ice
        mob:setSpellList(461)
        mob:addStatusEffect(xi.effect.ICE_SPIKES, 10, 0, duration)
        mob:addStatusEffect(xi.effect.ENBLIZZARD, 10, 0, duration)
        mob:setMod(xi.mod.ICE_MEVA, 200)
        mob:setMod(xi.mod.BINDRES, 100)
        mob:setMod(xi.mod.PARALYZERES, 100)
    elseif phase == 3 then -- Wind
        mob:setSpellList(462)
        mob:setMod(xi.mod.BLINK, 1)
        mob:addStatusEffect(xi.effect.ENAERO, 10, 0, duration)
        mob:setMod(xi.mod.WIND_MEVA, 200)
    elseif phase == 4 then -- Earth
        mob:setSpellList(463)
        mob:addStatusEffect(xi.effect.ENSTONE, 10, 0, duration)
        mob:setMod(xi.mod.EARTH_MEVA, 200)
        mob:setMod(xi.mod.SLOWRES, 100)
        mob:setMod(xi.mod.STONESKIN, 750)
    elseif phase == 5 then -- Thunder
        mob:setSpellList(464)
        mob:addStatusEffect(xi.effect.SHOCK_SPIKES, 10, 0, duration)
        mob:addStatusEffect(xi.effect.ENTHUNDER, 10, 0, duration)
        mob:setMod(xi.mod.THUNDER_MEVA, 200)
        mob:setMod(xi.mod.STUNRES, 100)
    else -- Water
        mob:setSpellList(465)
        mob:addStatusEffect(xi.effect.ENWATER, 10, 0, duration)
        mob:setMod(xi.mod.WATER_MEVA, 200)
        mob:setMod(xi.mod.POISONRES, 100)
    end
end

local function attackPattern(mob, info)
    local doubleRate, tripleRate, quadrupleRate = info[1], info[2], info[3]
    mob:setMod(xi.mod.DOUBLE_ATTACK, doubleRate)
    mob:setMod(xi.mod.TRIPLE_ATTACK, tripleRate)
    mob:setMod(xi.mod.QUAD_ATTACK, quadrupleRate)
end

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    mob:setMobMod(xi.mobMod.DRAW_IN, 1)
    mob:setMod(xi.mod.GRAVITYRES, 100)
    mob:setMod(xi.mod.LIGHT_MEVA, 54)
    mob:setMod(xi.mod.LIGHT_SDT, 54)
    mob:setMod(xi.mod.DARK_MEVA, 200)
    mob:setMod(xi.mod.DARK_SDT, 200)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 100)
    mob:setMod(xi.mod.LULLABYRES, 25)
    mob:setMod(xi.mod.SLEEPRES, 80)
    mob:setMod(xi.mod.SILENCERES, 100)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)

    changePhase(mob, math.random(1,6))
end)

m:addOverride(modulePath .. '.onMobFight', function(mob)
    -- Setup Attack Modifiers
    local hppIndex = utils.clamp(math.floor(mob:getHPP() / 10), 0, 9) % 10 -- simple split across 10% intervals
    local hppTable = {
--   hppRange  DA, TA, QA
        [9] = {80, 20, 0},
        [8] = {60, 40, 0},
        [7] = {50, 50, 0},
        [6] = {40, 60, 0},
        [5] = {20, 80, 0},
        [4] = {0, 100, 0},
        [3] = {0, 80, 20},
        [2] = {0, 50, 50},
        [1] = {0, 30, 70},
        [0] = {0, 20, 80},
    }

    attackPattern(mob, hppTable[hppIndex])
end)

m:addOverride(modulePath .. '.onAdditionalEffect', function(mob, target, damage)
    if mob:getLocalVar('spellstate') == 1 then -- Fire
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.PLAGUE, {chance = 100})
    elseif mob:getLocalVar('spellstate') == 2 then -- Ice
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.PARALYZE, {chance = 100})
    elseif mob:getLocalVar('spellstate') == 3 then -- Wind
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.SILENCE, {chance = 100})
    elseif mob:getLocalVar('spellstate') == 4 then -- Earth
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.PETRIFY, {chance = 100})
    elseif mob:getLocalVar('spellstate') == 5 then -- Thunder
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.STUN, {chance = 100})
    elseif mob:getLocalVar('spellstate') == 6 then -- Water
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.POISON, {chance = 100})
    end
end)

m:addOverride(modulePath .. '.onMobWeaponSkill', function(target, mob, skill)
    if skill:getID() == 2106 then -- Bloodrake (Fire)
        changePhase(mob, 1)
    elseif skill:getID() == 2111 then -- Eternal Damnation (Ice)
        changePhase(mob, 2)
    elseif skill:getID() == 2110 then -- Wings of Gehenna (Wind)
        changePhase(mob, 3)
    elseif skill:getID() == 2109 then -- Heliovoid (Earth)
        changePhase(mob, 4)
    elseif skill:getID() == 2107 then -- Decollation (Thunder)
        changePhase(mob, 5)
    elseif skill:getID() == 2108 then -- Nosferatu's Kiss (Water)
        changePhase(mob, 6)
    end
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    if player then
        xi.hunts.checkHunt(mob, player, 478)
        player:addTitle(xi.title.OUPIRE_IMPALER)
    end
end)

return m
