-----------------------------------
-- Area: Arrapago Reef
--  Mob: Lamia's Avatar (Lamie No.9 pet)
-----------------------------------
require('modules/module_utils')
require('scripts/mixins/rage')
-----------------------------------
local m = Module:new('lamias_avatar')

local modulePath = 'xi.zones.Arrapago_Reef.mobs.Lamias_Avatar'

xi.module.ensureTable(modulePath)

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.STUN)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    local respawnTime = math.random(60, 90) + os.time()
    mob:setLocalVar('respawn', respawnTime)
end)

return m
