-----------------------------------
-- Fomor Kings
-- Area: The Eldieme Necropolis [S]
-- Mob: Tehtra
-- Author: GM Hax
-- Features:
-- weak to wind, high meva / sdt to all other elements
-- 30 min rage timer
-- idle despawn will set once damage is started, fast depop
-- drawn in alliance on a cooldown, trigger is target greater than melee range
-- enmity decay every 30-45 seconds
-- large enmity vs pet masters on pet atk commands
-- enchanced enmity on physical damage taken / ws used vs, on a 10s recast
-- level up on offensive player JA used vs, on a cooldown
-- casting any magic against it will trigger a magic reflect with a stone 4, locked behind a cooldown
-- mannafont job special, enchanced triple attack while active
-- quake spell will be a radial aoe
-----------------------------------
require('modules/module_utils')
require('scripts/globals/hunts')
require('scripts/mixins/fomor_hate')
require('scripts/mixins/job_special')
require('scripts/mixins/rage')
-----------------------------------
local m = Module:new('fomor_tethra')

local modulePath = 'xi.zones.The_Eldieme_Necropolis_[S].mobs.Tethra'

xi.module.ensureTable('xi.zones.The_Eldieme_Necropolis_[S].mobs.Tethra')

local jobAbilities = set {
    xi.jobAbility.PROVOKE,
    xi.jobAbility.STEAL,
    xi.jobAbility.SHIELD_BASH,
    xi.jobAbility.JUMP,
    xi.jobAbility.HIGH_JUMP,
    xi.jobAbility.WEAPON_BASH,
    xi.jobAbility.CHI_BLAST,
    xi.jobAbility.TOMAHAWK,
    xi.jobAbility.BLADE_BASH,
    xi.jobAbility.ANGON,
    xi.jobAbility.QUICKSTEP,
    xi.jobAbility.BOXSTEP,
    xi.jobAbility.STUTTER_STEP,
    xi.jobAbility.FEATHER_STEP,
}

local petAbilities = set {
    xi.jobAbility.FIGHT,
    xi.jobAbility.ASSAULT,
    xi.jobAbility.DEPLOY,
}

local spawnPos = { x = 113.621, y = 9.980, z = -81.806, rotation = 54 }  -- fix

local function canPerformAction(mob)
    local act = mob:getCurrentAction()
    local isBusy = act == xi.act.MOBABILITY_START
        or act == xi.act.MOBABILITY_USING
        or act == xi.act.MOBABILITY_FINISH
        or act == xi.act.MAGIC_CASTING
        or act == xi.act.MAGIC_START
        or act == xi.act.MAGIC_FINISH

    local isActionQueueEmpty = mob:actionQueueEmpty()
    local isAlive = mob:isAlive()
    local canAct = isAlive and isActionQueueEmpty and not isBusy

    return canAct
end

local function drawInController(mob, target)
    local drawInRecast = mob:getLocalVar('drawInRecast')
    mob:setMobMod(xi.mobMod.DRAW_IN, 2)
    mob:resetEnmity(target)
    mob:setLocalVar('drawInRecast', os.time() + math.random(5, 10))
    mob:timer(4000, function(mobArg)
        mobArg:addTP(3000)
        mobArg:setMobMod(xi.mobMod.DRAW_IN, 0)
    end)
end

local function levelUp(mob)
    local currentTime = os.time()
    mob:injectActionPacket(mob:getID(), 4, 5000, 0, 0, 0, 0, 0)
    mob:setLocalVar('levelUpRecast', currentTime + math.random(15, 45))
    mob:addMod(xi.mod.ATT, 25)
    mob:addMod(xi.mod.DEF, 25)
    mob:addMod(xi.mod.HP, 5000)
    mob:addMod(xi.mod.REGEN, 5)
    mob:updateHealth()
    mob:setHP(mob:getMaxHP())
end

local function absorbEffects(mob, absorbValue, applyShield)
    mob:setMod(xi.mod.FIRE_ABSORB, absorbValue)
    mob:setMod(xi.mod.EARTH_ABSORB, absorbValue)
    mob:setMod(xi.mod.WATER_ABSORB, absorbValue)
    mob:setMod(xi.mod.WIND_ABSORB, absorbValue)
    mob:setMod(xi.mod.ICE_ABSORB, absorbValue)
    mob:setMod(xi.mod.LTNG_ABSORB, absorbValue)
    mob:setMod(xi.mod.LIGHT_ABSORB, absorbValue)
    mob:setMod(xi.mod.DARK_ABSORB, absorbValue)

    if applyShield then
        mob:addStatusEffectEx(xi.effect.PHYSICAL_SHIELD, 1, 1, 0, 0)
    else
        mob:delStatusEffectSilent(xi.effect.PHYSICAL_SHIELD)
    end
end

local function enmityDecay(mob, target)
    mob:lowerEnmity(target, 75)  -- 75% enmity reduction
end

m:addOverride(modulePath .. '.onMobInitialize', function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
end)

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    mob:setMod(xi.mod.FIRE_MEVA, 300)  -- weak to wind. high meva / sdt to all other elements.
    mob:setMod(xi.mod.ICE_MEVA, 300)
    mob:setMod(xi.mod.EARTH_MEVA, -50)
    mob:setMod(xi.mod.THUNDER_MEVA, 300)
    mob:setMod(xi.mod.WATER_MEVA, 300)
    mob:setMod(xi.mod.LIGHT_MEVA, 300)
    mob:setMod(xi.mod.DARK_MEVA, 300)
    mob:setMod(xi.mod.FIRE_SDT, 300)
    mob:setMod(xi.mod.ICE_SDT, 300)
    mob:setMod(xi.mod.EARTH_SDT, 300)
    mob:setMod(xi.mod.THUNDER_SDT, 300)
    mob:setMod(xi.mod.WATER_SDT, 300)
    mob:setMod(xi.mod.LIGHT_SDT, 300)
    mob:setMod(xi.mod.DARK_SDT, 300)
    mob:setMod(xi.mod.REGEN, 15)  -- ini for this
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.TERROR)
    mob:addMod(xi.mod.ACC, 46) -- 400 total acc
    mob:addMod(xi.mod.ATT, 95) -- 500 total atk
    mob:addMod(xi.mod.DEF, 153) -- 500 total def
    mob:addMod(xi.mod.EVA, 35) -- 375 total eva
    mob:addMod(xi.mod.STR, 8)    -- 90 total str
    mob:addMod(xi.mod.DEX, 14)   -- 90 total dex
    mob:addMod(xi.mod.VIT, 16)   -- 85 total vit
    mob:addMod(xi.mod.AGI, 14)   -- 90 total agi
    mob:addMod(xi.mod.MND, 5)    -- 90 total mnd
    mob:addMod(xi.mod.INT, -19)  -- 80 total int
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.UFASTCAST, 35)
    mob:addMod(xi.mod.REGAIN, 20)
    mob:setLocalVar('wsBonusRecast', 0)
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:setLocalVar('levelUpRecast', os.time() + math.random(5, 15))  -- ini setup
    mob:setLocalVar('enmityDecayTime', os.time() + 30)  -- ini setup
    mob:addListener('ABILITY_TAKE', 'TETHRA_PLAYER_JA_USED', function(mobArg, player, ability, action)
        local currentTime = os.time()
        local levelUpRecast = mobArg:getLocalVar('levelUpRecast')

        if canPerformAction(mobArg) then
            if currentTime > levelUpRecast then
                if jobAbilities[ability:getID()] then
                    mobArg:queue(0, function(mobArg)
                        levelUp(mobArg)
                    end)
                end
            end
        end

        if petAbilities[ability:getID()] then
            mobArg:addEnmity(player, 0, 1800)
        end
    end)
    mob:addListener('MAGIC_TAKE', 'TETHRA_MAGIC_TAKE', function(target, caster, spell)
        local currentTime = os.time()
        local magicReflectRecast = target:getLocalVar('magicReflectRecast')

        if spell:tookEffect() and (caster:isPC() or caster:isPet()) then
            if currentTime > magicReflectRecast then
                target:setLocalVar('magicReflect', 1)
                target:setLocalVar('magicReflectRecast', currentTime + math.random(15, 30))
            end
        end
    end)
    mob:addListener('TAKE_DAMAGE', 'TETHRA_TAKE_DAMAGE', function(mobArg, amount, attacker, attackType, damageType)
        local currentTime = os.time()
        local lastTakeDamageTime = mobArg:getLocalVar('lastTakeDamageTime')

        if currentTime > lastTakeDamageTime + 10 then
            lastTakeDamageTime = currentTime

            if attackType == xi.attackType.PHYSICAL then
                mobArg:addEnmity(attacker, 500, 500)
            end
        end
    end)
    mob:addListener('WEAPONSKILL_TAKE', 'TETHRA_WEAPONSKILL_TAKE', function(targetArg, attacker, skillid, tp, action)
        local currentTime = os.time()
        local lastWeaponSkillTakeTime = targetArg:getLocalVar('lastWeaponSkillTakeTime')

        if currentTime > lastWeaponSkillTakeTime + 10 then
            lastWeaponSkillTakeTime = currentTime

            targetArg:addEnmity(attacker, 500, 500)
        end
    end)
    mob:addListener('MAGIC_START', 'TETHRA_MAGIC_HEAL_START', function(mobArg, spell, action)
        absorbEffects(mobArg, 100, true)
    end)

    mob:addListener('MAGIC_STATE_EXIT', 'TETHRA_MAGIC_HEAL_EXIT', function(mobArg, spell)
        absorbEffects(mobArg, 0, false)
    end)
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {
                id = xi.jsa.MANAFONT,
                cooldown = math.random(90, 120),
                hpp = 35,
            },
        },
    })
end)

m:addOverride(modulePath .. '.onAdditionalEffect', function(mob, target, damage)
    if math.random(0, 1) == 0 then
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.PETRIFY, {chance = 35, duration = math.random(5, 10)})
    else
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENSTONE, {power = math.random(16, 35)})
    end
end)

m:addOverride(modulePath .. '.onMobFight', function(mob, target)
    local time = os.time()
    local drawInRecast = mob:getLocalVar('drawInRecast')
    local magicReflect = mob:getLocalVar('magicReflect')
    local magicReflectRecast = mob:getLocalVar('magicReflectRecast')
    local enmityDecayTime = mob:getLocalVar('enmityDecayTime')
    local lifePercent = mob:getHPP()
    local idleDespawnTrigger = mob:getLocalVar("idleDespawnTrigger")
    local lastDrawInCheck = mob:getLocalVar('lastDrawInCheck')

    if lifePercent < 99 and idleDespawnTrigger == 0 then
        mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 10)
        mob:setLocalVar("idleDespawnTrigger", 1)
    end

    if time > lastDrawInCheck + 2 then
        mob:setLocalVar('lastDrawInCheck', time)

        if target then
            local distance = mob:checkDistance(target)
            if distance and distance > 5 and time > drawInRecast then
                drawInController(mob, target)
            end
        end
    end

    if magicReflect == 1 then
        if canPerformAction(mob) then
            mob:castSpell(xi.magic.spell.STONE_IV, target)
            mob:setLocalVar('magicReflect', 0)
        end
    end

    if time > enmityDecayTime then
        enmityDecay(mob, target)
        mob:setLocalVar('enmityDecayTime', time + math.random(30, 45))
    end
end)

m:addOverride(modulePath .. '.onSpellPrecast', function(mob, spell)
    if spell:getID() == xi.magic.spell.QUAKE then
        if math.random() <= 0.5 then  -- 50% chance
            spell:setAoE(xi.magic.aoe.RADIAL)
            spell:setFlag(xi.magic.spellFlag.HIT_ALL)
            spell:setRadius(18)
        end
    end
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    xi.hunts.checkHunt(mob, player, 496)
    player:setTitle(xi.title.TETHRA_EXORCIST)
end)

m:addOverride(modulePath .. '.onMobDespawn', function(mob)
    mob:resetLocalVars()
    mob:removeListener('ABILITY_TAKE', 'TETHRA_PLAYER_JA_USED')
    mob:removeListener('MAGIC_TAKE', 'TETHRA_MAGIC_TAKE')
    mob:removeListener('TAKE_DAMAGE', 'TETHRA_TAKE_DAMAGE')
    mob:removeListener('WEAPONSKILL_TAKE', 'TETHRA_WEAPONSKILL_TAKE')
    mob:removeListener('MAGIC_START', 'TETHRA_MAGIC_HEAL_START')
    mob:removeListener('MAGIC_STATE_EXIT', 'TETHRA_MAGIC_HEAL_EXIT')
    mob:removeListener('WEAPONSKILL_STATE_EXIT', 'TETHRA_BONUS_WS')
end)

m:addOverride('xi.actions.spells.blue.filamented_hold.onSpellCast', function(caster, target, spell)
    local mobName = caster:getName()

    if caster:isMob() and mobName == 'Tethra' then
        local params = {}
        params.ecosystem = xi.ecosystem.VERMIN
        params.effect = xi.effect.SLOW
        local power = 2500
        local tick = 0
        local duration = 90
        local resistThreshold = 0
        local isGaze = false
        local isConal = true

        return xi.spells.blue.useEnfeeblingSpell(caster, target, spell, params, power, tick, duration, resistThreshold, isGaze, isConal)
    else
        return super(caster, target, spell)
    end
end)

return m
