-----------------------------------
-- Fomor Kings
-- Area: The Eldieme Necropolis [S]
-- Mob: Ethniu
-- Author: GM Hax
-- Features:
-- weak to ice, high meva / sdt to all other elements
-- 30 min rage timer
-- idle despawn will set once damage is started, fast depop
-- drawn in alliance on a cooldown, trigger is target greater than melee range
-- enmity decay every 30-45 seconds
-- large enmity vs pet masters on pet atk commands
-- enchanced enmity on physical damage taken / ws used vs, on a 10s recast
-- level up on physical damage taken, 5% chance to level up, max 10 times
-- casting any magic against it will trigger a magic reflect with a wind 4, locked behind a cooldown
-- dagger ws bonus, 50% chance to use a secondary ws after using gust slash, evisceration, or aeolian edge
-- perfect dodge job special, enchanced triple attack while active
-- tornado spell will be a radial aoe
-----------------------------------
require('modules/module_utils')
require('scripts/globals/hunts')
require('scripts/mixins/fomor_hate')
require('scripts/mixins/job_special')
require('scripts/mixins/rage')
-----------------------------------
local m = Module:new('fomor_ethniu')

local modulePath = 'xi.zones.The_Eldieme_Necropolis_[S].mobs.Ethniu'

xi.module.ensureTable('xi.zones.The_Eldieme_Necropolis_[S].mobs.Ethniu')

local petAbilities = set {
    xi.jobAbility.FIGHT,
    xi.jobAbility.ASSAULT,
    xi.jobAbility.DEPLOY,
}

local spawnPos = { x = 153.554, y = 14.840, z = 286.063, rotation = 0 }

local function canPerformAction(mob)
    local act = mob:getCurrentAction()
    local isBusy = act == xi.act.MOBABILITY_START
        or act == xi.act.MOBABILITY_USING
        or act == xi.act.MOBABILITY_FINISH
        or act == xi.act.MAGIC_CASTING
        or act == xi.act.MAGIC_START
        or act == xi.act.MAGIC_FINISH

    local isActionQueueEmpty = mob:actionQueueEmpty()
    local isAlive = mob:isAlive()
    local canAct = isAlive and isActionQueueEmpty and not isBusy

    return canAct
end

local function drawInController(mob, target)
    local drawInRecast = mob:getLocalVar('drawInRecast')
    mob:setMobMod(xi.mobMod.DRAW_IN, 2)
    mob:resetEnmity(target)
    mob:setLocalVar('drawInRecast', os.time() + math.random(5, 10))
    mob:timer(4000, function(mobArg)
        mobArg:addTP(3000)
        mobArg:setMobMod(xi.mobMod.DRAW_IN, 0)
    end)
end

local function levelUp(mob)
    if math.random(1, 4) ~= 1 then  -- 25% chance to level up
        return
    end

    local totalLevelUps = mob:getLocalVar('totalLevelUps')

    if totalLevelUps >= 5 then
        return
    end

    mob:injectActionPacket(mob:getID(), 4, 5000, 0, 0, 0, 0, 0)
    mob:addMod(xi.mod.ATT, 15)
    mob:addMod(xi.mod.DEF, 15)
    mob:addMod(xi.mod.HP, 2500)
    mob:addMod(xi.mod.REGEN, 2)
    mob:updateHealth()
    mob:setHP(mob:getMaxHP())
    mob:setLocalVar('totalLevelUps', totalLevelUps + 1)
    mob:setLocalVar('levelUpRecast', os.time() + math.random(90, 180))
end


local function enmityDecay(mob, target)
    mob:lowerEnmity(target, 75)  -- 75% enmity reduction
end

m:addOverride(modulePath .. '.onMobInitialize', function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
end)

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    mob:setMod(xi.mod.FIRE_MEVA, 300)  -- weak to ice. high meva / sdt to all other elements.
    mob:setMod(xi.mod.WIND_MEVA, 300)
    mob:setMod(xi.mod.EARTH_MEVA, 300)
    mob:setMod(xi.mod.THUNDER_MEVA, 300)
    mob:setMod(xi.mod.WATER_MEVA, 300)
    mob:setMod(xi.mod.LIGHT_MEVA, 300)
    mob:setMod(xi.mod.DARK_MEVA, 300)
    mob:setMod(xi.mod.FIRE_SDT, 300)
    mob:setMod(xi.mod.WIND_SDT, 300)
    mob:setMod(xi.mod.EARTH_SDT, 300)
    mob:setMod(xi.mod.THUNDER_SDT, 300)
    mob:setMod(xi.mod.WATER_SDT, 300)
    mob:setMod(xi.mod.LIGHT_SDT, 300)
    mob:setMod(xi.mod.DARK_SDT, 300)
    mob:setMod(xi.mod.REGEN, 15)  -- ini for this
    mob:setMod(xi.mod.TRIPLE_ATTACK, 10)
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.TERROR)
    mob:addMod(xi.mod.ACC, 46)   -- 400 total acc
    mob:addMod(xi.mod.ATT, 95)   -- 500 total atk
    mob:addMod(xi.mod.DEF, 153)  -- 500 total def
    mob:addMod(xi.mod.EVA, 35)   -- 375 total eva
    mob:addMod(xi.mod.STR, 8)    -- 90 total str
    mob:addMod(xi.mod.DEX, 14)   -- 90 total dex
    mob:addMod(xi.mod.VIT, 16)   -- 85 total vit
    mob:addMod(xi.mod.AGI, 19)   -- 90 total agi
    mob:addMod(xi.mod.MND, 5)    -- 90 total mnd
    mob:addMod(xi.mod.INT, -19)  -- 80 total int
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.UFASTCAST, 35)
    mob:addMod(xi.mod.REGAIN, 20)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMobMod(xi.mobMod.MULTI_HIT, 1)
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:setLocalVar('levelUpRecast', os.time() + math.random(5, 15))  -- ini setup
    mob:setLocalVar('enmityDecayTime', os.time() + 30)  -- ini setup
    mob:addListener('ABILITY_TAKE', 'ETHNIU_PET_ABILITY_USED', function(mobArg, player, ability, action)
        if petAbilities[ability:getID()] then
            mobArg:addEnmity(player, 0, 1800)
        end
    end)
    mob:addListener('MAGIC_TAKE', 'ETHNIU_MAGIC_TAKE', function(target, caster, spell)
        local currentTime = os.time()
        local magicReflectRecast = target:getLocalVar('magicReflectRecast')

        if spell:tookEffect() and (caster:isPC() or caster:isPet()) then
            if currentTime > magicReflectRecast then
                target:setLocalVar('magicReflect', 1)
                target:setLocalVar('magicReflectRecast', currentTime + math.random(15, 30))
            end
        end
    end)
    mob:addListener('EFFECT_LOSE', 'ETHNIU_SP_END', function(mobArg, effect)
        if effect:getEffectType() == xi.effect.PERFECT_DODGE then
            mobArg:setMod(xi.mod.TRIPLE_ATTACK, 10)
            mobArg:setMagicCastingEnabled(true)
        end
    end)
    mob:addListener('TAKE_DAMAGE', 'ETHNIU_TAKE_DAMAGE', function(mobArg, amount, attacker, attackType, damageType)
        local currentTime = os.time()
        local lastTakeDamageTime = mobArg:getLocalVar('lastTakeDamageTime')

        if currentTime > lastTakeDamageTime + 10 then
            mobArg:setLocalVar('lastTakeDamageTime', currentTime)

            if attackType == xi.attackType.PHYSICAL then
                mobArg:addEnmity(attacker, 500, 500)

                if canPerformAction(mobArg) then
                    if currentTime > mobArg:getLocalVar('levelUpRecast') then
                        mobArg:queue(0, function(mobArg)
                            levelUp(mobArg)
                        end)
                    end
                end
            end
        end
    end)
    mob:addListener('WEAPONSKILL_TAKE', 'ELATHA_WEAPONSKILL_TAKE', function(targetArg, attacker, skillid, tp, action)
        local currentTime = os.time()
        local lastWeaponSkillTakeTime = targetArg:getLocalVar('lastWeaponSkillTakeTime')

        if currentTime > lastWeaponSkillTakeTime + 10 then
            lastWeaponSkillTakeTime = currentTime

            targetArg:addEnmity(attacker, 500, 500)
        end
    end)
    mob:addListener('WEAPONSKILL_STATE_EXIT', 'ELATHA_BONUS_WS', function(mobArg, skillID)
        local gustSlash = xi.weaponskill.GUST_SLASH
        local evisceration = xi.weaponskill.EVISCERATION
        local aeolianEdge = xi.weaponskill.AEOLIAN_EDGE
        local repeatSkill = math.random() <= 0.5  -- 50% chance
        local currentTime = os.time()
        local wsBonusRecast = mobArg:getLocalVar('wsBonusRecast') or 0

        if (skillID == gustSlash or skillID == evisceration or skillID == aeolianEdge) and currentTime > wsBonusRecast then
            if repeatSkill then
                mobArg:setLocalVar('wsBonusRecast', currentTime + 60)
                mob:useMobAbility(skillID)
            end
        end
    end)
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {
                id = xi.jsa.PERFECT_DODGE,
                cooldown = math.random(90, 120),
                hpp = 35,
                endCode = function(mobArg)
                    mobArg:addMod(xi.mod.HASTE_ABILITY, 2500)
                    mobArg:setMagicCastingEnabled(false)
                    mobArg:setMod(xi.mod.TRIPLE_ATTACK, 20)
                end,
            },
        },
    })
end)

m:addOverride(modulePath .. '.onAdditionalEffect', function(mob, target, damage)
    if math.random(0, 1) == 0 then
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.SILENCE, {chance = 75, duration = math.random(30, 45)})
    else
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENAERO, {power = math.random(16, 35)})
    end
end)

m:addOverride(modulePath .. '.onMobFight', function(mob, target)
    local time = os.time()
    local drawInRecast = mob:getLocalVar('drawInRecast')
    local magicReflect = mob:getLocalVar('magicReflect')
    local magicReflectRecast = mob:getLocalVar('magicReflectRecast')
    local enmityDecayTime = mob:getLocalVar('enmityDecayTime')
    local lifePercent = mob:getHPP()
    local idleDespawnTrigger = mob:getLocalVar("idleDespawnTrigger")
    local lastDrawInCheck = mob:getLocalVar('lastDrawInCheck')

    if lifePercent < 99 and idleDespawnTrigger == 0 then
        mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 10)
        mob:setLocalVar("idleDespawnTrigger", 1)
    end

    if time > lastDrawInCheck + 2 then
        mob:setLocalVar('lastDrawInCheck', time)

        if target then
            local distance = mob:checkDistance(target)
            if distance and distance > 5 and time > drawInRecast then
                drawInController(mob, target)
            end
        end
    end

    if magicReflect == 1 then
        if canPerformAction(mob) then
            mob:castSpell(xi.magic.spell.AERO_IV, target)
            mob:setLocalVar('magicReflect', 0)
        end
    end

    if time > enmityDecayTime then
        enmityDecay(mob, target)
        mob:setLocalVar('enmityDecayTime', time + math.random(30, 45))
    end
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    xi.hunts.checkHunt(mob, player, 497)
    player:setTitle(xi.title.ETHNIU_EXORCIST)
end)

m:addOverride(modulePath .. '.onMobDespawn', function(mob)
    mob:resetLocalVars()
    mob:removeListener('ETHNIU_PET_ABILITY_USED')
    mob:removeListener('ETHNIU_MAGIC_TAKE')
    mob:removeListener('ETHNIU_SP_END')
    mob:removeListener('ELATHA_TAKE_DAMAGE')
    mob:removeListener('ELATHA_WEAPONSKILL_TAKE')
    mob:removeListener('ELATHA_BONUS_WS')
end)

m:addOverride('xi.actions.spells.blue.frightful_roar.onSpellCast', function(caster, target, spell)
    local mobName = caster:getName()

    if caster:isMob() and mobName == 'Ethniu' then
        local params = {}
        params.ecosystem = xi.ecosystem.DEMON
        params.effect = xi.effect.DEFENSE_DOWN
        local power = 35
        local tick = 0
        local duration = 180
        local resistThreshold = 0
        local isGaze = false
        local isConal = false

        target:addStatusEffect(xi.effect.DEFENSE_DOWN, 1, tick, duration)
        return xi.spells.blue.useEnfeeblingSpell(caster, target, spell, params, power, tick, duration, resistThreshold, isGaze, isConal)
    else
        return super(caster, target, spell)
    end
end)

return m
