-----------------------------------
-- Fomor Kings
-- Area: Garlaige Citadel [S]
-- Mob: Elatha
-- Author: GM Hax
-- Features:
-- weak to fire, high meva / sdt to all other elements
-- 30 min rage timer
-- idle despawn will set once damage is started, fast depop
-- drawn in alliance on a cooldown, trigger is target greater than melee range
-- enmity decay every 30-45 seconds
-- large enmity vs pet masters on pet atk commands
-- enchanced enmity on physical damage taken / ws used vs, on a 10s recast
-- greatsword ws bonus, 50% chance to use a secondary ws
-- all weaponskills get boosted tp
-- level up on magic used vs, locked behind a cooldown
-- casting any magic against it will trigger a magic reflect with a blizard 4, locked behind a cooldown
-- enblizzard / paralyze on hit
-- while casting spells or using a ws dmg taken will heal it
-- while casting spells or using a ws magic dmg taken will heal it, unless its fire element
-- blood weapon unlocked at 35% hp, 90-120s cooldown. para aura / haste and no magic casting during.
-----------------------------------
require('modules/module_utils')
require('scripts/globals/hunts')
require('scripts/mixins/fomor_hate')
require('scripts/mixins/job_special')
require('scripts/mixins/rage')
-----------------------------------
local m = Module:new('fomor_elatha')

local modulePath = 'xi.zones.Garlaige_Citadel_[S].mobs.Elatha'

xi.module.ensureTable('xi.zones.Garlaige_Citadel_[S].mobs.Elatha')

local petAbilities = set{
    xi.jobAbility.FIGHT,
    xi.jobAbility.ASSAULT,
    xi.jobAbility.DEPLOY,
}

local spawnPos = { x = -137.193, y = -0.500, z = -100.000, rotation = 119 }

local function canPerformAction(mob)
    local act = mob:getCurrentAction()
    local isBusy = act == xi.act.MOBABILITY_START
        or act == xi.act.MOBABILITY_USING
        or act == xi.act.MOBABILITY_FINISH
        or act == xi.act.MAGIC_CASTING
        or act == xi.act.MAGIC_START
        or act == xi.act.MAGIC_FINISH

    local isActionQueueEmpty = mob:actionQueueEmpty()
    local isAlive = mob:isAlive()
    local canAct = isAlive and isActionQueueEmpty and not isBusy

    return canAct
end

local function drawInController(mob, target)
    local drawInRecast = mob:getLocalVar('drawInRecast')
    mob:setMobMod(xi.mobMod.DRAW_IN, 2)
    mob:resetEnmity(target)
    mob:setLocalVar('drawInRecast', os.time() + math.random(5, 10))
    mob:timer(4000, function(mobArg)
        mobArg:addTP(3000)
        mobArg:setMobMod(xi.mobMod.DRAW_IN, 0)
    end)
end

local function levelUp(mob)
    local currentTime = os.time()
    mob:injectActionPacket(mob:getID(), 4, 5000, 0, 0, 0, 0, 0)
    mob:setLocalVar('levelUpRecast', currentTime + math.random(15, 45))
    mob:addMod(xi.mod.ATT, 25)
    mob:addMod(xi.mod.DEF, 25)
    mob:addMod(xi.mod.HP, 5000)
    mob:addMod(xi.mod.REGEN, 5)
    mob:updateHealth()
    mob:setHP(mob:getMaxHP())
end

local function enmityDecay(mob, target)
    mob:lowerEnmity(target, 75)  -- 75% enmity reduction
end

local function absorbEffects(mob, absorbValue, applyShield)
    mob:setMod(xi.mod.EARTH_ABSORB, absorbValue)  -- absorb all elements except fire.
    mob:setMod(xi.mod.WATER_ABSORB, absorbValue)
    mob:setMod(xi.mod.WIND_ABSORB, absorbValue)
    mob:setMod(xi.mod.ICE_ABSORB, absorbValue)
    mob:setMod(xi.mod.LTNG_ABSORB, absorbValue)
    mob:setMod(xi.mod.LIGHT_ABSORB, absorbValue)
    mob:setMod(xi.mod.DARK_ABSORB, absorbValue)

    if applyShield then
        mob:addStatusEffectEx(xi.effect.PHYSICAL_SHIELD, 1, 2, 0, 0)
    else
        mob:delStatusEffectSilent(xi.effect.PHYSICAL_SHIELD)
    end
end

m:addOverride(modulePath .. '.onMobInitialize', function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
end)

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    mob:setMod(xi.mod.ICE_MEVA, 300)  -- weak to fire. high meva / sdt to all other elements.
    mob:setMod(xi.mod.WIND_MEVA, 300)
    mob:setMod(xi.mod.EARTH_MEVA, 300)
    mob:setMod(xi.mod.THUNDER_MEVA, 300)
    mob:setMod(xi.mod.WATER_MEVA, 300)
    mob:setMod(xi.mod.LIGHT_MEVA, 300)
    mob:setMod(xi.mod.DARK_MEVA, 300)
    mob:setMod(xi.mod.ICE_SDT, 300)
    mob:setMod(xi.mod.WIND_SDT, 300)
    mob:setMod(xi.mod.EARTH_SDT, 300)
    mob:setMod(xi.mod.THUNDER_SDT, 300)
    mob:setMod(xi.mod.WATER_SDT, 300)
    mob:setMod(xi.mod.LIGHT_SDT, 300)
    mob:setMod(xi.mod.DARK_SDT, 300)
    mob:setMod(xi.mod.REGEN, 15)  -- ini for this
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.TERROR)
    mob:addMod(xi.mod.ACC, 46)   -- 400 total acc
    mob:addMod(xi.mod.ATT, 95)   -- 500 total atk
    mob:addMod(xi.mod.DEF, 153)  -- 500 total def
    mob:addMod(xi.mod.EVA, 35)   -- 375 total eva
    mob:addMod(xi.mod.DEX, 9)    -- 90 total dex
    mob:addMod(xi.mod.VIT, 7)    -- 85 total vit
    mob:addMod(xi.mod.AGI, 10)   -- 90 total agi
    mob:addMod(xi.mod.MND, 23)   -- 90 total mnd
    mob:addMod(xi.mod.INT, -19)  -- 80 total int
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.UFASTCAST, 35)
    mob:addMod(xi.mod.REGAIN, 20)
    mob:addStatusEffect(xi.effect.ICE_SPIKES, math.random(15,25), 0, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:setLocalVar('levelUpRecast', os.time() + math.random(5, 15))  -- ini setup
    mob:setLocalVar('enmityDecayTime', os.time() + 30)  -- ini setup
    mob:addListener('ABILITY_TAKE', 'ELATHA_PET_ABILITY_USED', function(mobArg, player, ability, action)
        if petAbilities[ability:getID()] then
            mobArg:addEnmity(player, 0, 1800)
        end
    end)
    mob:addListener('MAGIC_TAKE', 'ELATHA_MAGIC_TAKE', function(target, caster, spell)
        local currentTime = os.time()
        local magicReflectRecast = target:getLocalVar('magicReflectRecast')

        if spell:tookEffect() and (caster:isPC() or caster:isPet()) then
            if currentTime > magicReflectRecast then
                target:setLocalVar('magicReflect', 1)
                target:setLocalVar('magicReflectRecast', currentTime + math.random(15, 30))
            end
            if canPerformAction(target) then
                if currentTime > target:getLocalVar('levelUpRecast') then
                    target:queue(0, function(targetArg)
                        levelUp(targetArg)
                    end)
                end
            end
        end
    end)
    mob:addListener('WEAPONSKILL_STATE_ENTER', 'ELATHA_WS_HEAL_START', function(mobArg, skillID)
        absorbEffects(mobArg, 100, true)
    end)

    mob:addListener('WEAPONSKILL_STATE_EXIT', 'ELATHA_WS_HEAL_EXIT', function(mobArg, skillID)
        absorbEffects(mobArg, 0, false)

        local powerSlash = xi.weaponskill.POWER_SLASH
        local sickleMoon = xi.weaponskill.SICKLE_MOON
        local groundStrike = xi.weaponskill.GROUND_STRIKE
        local repeatSkill = math.random() <= 0.5  -- 50% chance
        local currentTime = os.time()
        local wsBonusRecast = mobArg:getLocalVar('wsBonusRecast') or 0

        if (skillID == powerSlash or skillID == sickleMoon or skillID == groundStrike) and currentTime > wsBonusRecast then
            if repeatSkill then
                mobArg:setLocalVar('wsBonusRecast', currentTime + 60)  -- time gate
                mobArg:useMobAbility(skillID)
            end
        end
    end)

    mob:addListener('MAGIC_START', 'ELATHA_MAGIC_HEAL_START', function(mobArg, spell, action)
        absorbEffects(mobArg, 100, true)
    end)

    mob:addListener('MAGIC_STATE_EXIT', 'ELATHA_MAGIC_HEAL_EXIT', function(mobArg, spell)
        absorbEffects(mobArg, 0, false)
    end)
    mob:addListener('EFFECT_LOSE', 'ELATHA_SP_END', function(mobArg, effect)
        if effect:getEffectType() == xi.effect.BLOOD_WEAPON then
            mobArg:delMod(xi.mod.HASTE_ABILITY, 2500)
            mobArg:setMagicCastingEnabled(true)
            mobArg:setMobMod(xi.mobMod.MULTI_HIT, 0)
            mobArg:delStatusEffectSilent(xi.effect.COLURE_ACTIVE)
        end
    end)
    mob:addListener('TAKE_DAMAGE', 'ELATHA_TAKE_DAMAGE', function(mobArg, amount, attacker, attackType, damageType)
        local currentTime = os.time()
        local lastTakeDamageTime = mobArg:getLocalVar('lastTakeDamageTime')

        if currentTime > lastTakeDamageTime + 10 then
            lastTakeDamageTime = currentTime

            if attackType == xi.attackType.PHYSICAL then
                mobArg:addEnmity(attacker, 500, 500)
            end
        end
    end)
    mob:addListener('WEAPONSKILL_TAKE', 'ELATHA_WEAPONSKILL_TAKE', function(targetArg, attacker, skillid, tp, action)
        local currentTime = os.time()
        local lastWeaponSkillTakeTime = targetArg:getLocalVar('lastWeaponSkillTakeTime')

        if currentTime > lastWeaponSkillTakeTime + 10 then
            lastWeaponSkillTakeTime = currentTime

            targetArg:addEnmity(attacker, 500, 500)
        end
    end)
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {
                id = xi.jsa.BLOOD_WEAPON,
                cooldown = math.random(90, 120),
                hpp = 35,
                endCode = function(mobArg)
                    mobArg:addMod(xi.mod.HASTE_ABILITY, 2500)
                    mobArg:setMagicCastingEnabled(false)
                    mobArg:setMobMod(xi.mobMod.MULTI_HIT, 1)
                    mobArg:addStatusEffectEx(xi.effect.COLURE_ACTIVE, xi.effect.COLURE_ACTIVE, 6, 3, 0, xi.effect.PARALYSIS, 50, xi.auraTarget.ENEMIES, xi.effectFlag.AURA)
                end,
            },
        },
    })
end)

m:addOverride(modulePath .. '.onMobWeaponSkillPrepare', function(mob, target)
    mob:setTP(3000)  -- boosted ws dmg
end)

m:addOverride(modulePath .. '.onAdditionalEffect', function(mob, target, damage)
    if math.random(0, 1) == 0 then
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.PARALYZE, {chance = 75, duration = math.random(30, 45)})
    else
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENBLIZZARD, {power = math.random(16, 35)})
    end
end)

m:addOverride(modulePath .. '.onMobFight', function(mob, target)
    local time = os.time()
    local drawInRecast = mob:getLocalVar('drawInRecast')
    local magicReflect = mob:getLocalVar('magicReflect')
    local magicReflectRecast = mob:getLocalVar('magicReflectRecast')
    local enmityDecayTime = mob:getLocalVar('enmityDecayTime')
    local lifePercent = mob:getHPP()
    local idleDespawnTrigger = mob:getLocalVar("idleDespawnTrigger")
    local lastDrawInCheck = mob:getLocalVar('lastDrawInCheck')

    if lifePercent < 99 and idleDespawnTrigger == 0 then
        mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 10)
        mob:setLocalVar("idleDespawnTrigger", 1)
    end

    if time > lastDrawInCheck + 2 then
        mob:setLocalVar('lastDrawInCheck', time)

        if target then
            local distance = mob:checkDistance(target)
            if distance and distance > 5 and time > drawInRecast then
                drawInController(mob, target)
            end
        end
    end

    if magicReflect == 1 then
        if canPerformAction(mob) then
            mob:castSpell(xi.magic.spell.BLIZZARD_IV, target)
            mob:setLocalVar('magicReflect', 0)
        end
    end

    if time > enmityDecayTime then
        enmityDecay(mob, target)
        mob:setLocalVar('enmityDecayTime', time + math.random(30, 45))
    end
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    xi.hunts.checkHunt(mob, player, 535)
    player:setTitle(xi.title.ELATHA_EXORCIST)
end)

m:addOverride(modulePath .. '.onMobDespawn', function(mob)
    mob:resetLocalVars()
    mob:removeListener('ELATHA_PET_ABILITY_USED')
    mob:removeListener('ELATHA_MAGIC_TAKE')
    mob:removeListener('ELATHA_WS_HEAL_START')
    mob:removeListener('ELATHA_WS_HEAL_EXIT')
    mob:removeListener('ELATHA_MAGIC_HEAL_START')
    mob:removeListener('ELATHA_MAGIC_HEAL_EXIT')
    mob:removeListener('ELATHA_SP_END')
    mob:removeListener('ELATHA_TAKE_DAMAGE')
    mob:removeListener('ELATHA_WEAPONSKILL_TAKE')
end)

m:addOverride('xi.actions.spells.blue.ice_break.onSpellCast', function(caster, target, spell)
    local mobName = caster:getName()

    if caster:isMob() and mobName == 'Elatha' then
        local params = {}
        params.ecosystem = xi.ecosystem.ARCANA
        params.attackType = xi.attackType.MAGICAL
        params.damageType = xi.damageType.ICE
        params.attribute = xi.mod.INT
        params.multiplier = 2.25
        params.tMultiplier = 1.0
        params.duppercap = 69
        params.str_wsc = 0.0
        params.dex_wsc = 0.0
        params.vit_wsc = 0.0
        params.agi_wsc = 0.0
        params.int_wsc = 0.3
        params.mnd_wsc = 0.0
        params.chr_wsc = 0.0

        local tick = 0
        local duration = math.random(15, 30)

        local damage = xi.spells.blue.useMagicalSpell(caster, target, spell, params)
        local randomizedDamage = math.random(125, 225)
        target:addStatusEffect(xi.effect.BIND, 1, tick, duration)

        return randomizedDamage
    else
        return super(caster, target, spell)
    end
end)

m:addOverride('xi.actions.spells.blue.cold_wave.onSpellCast', function(caster, target, spell)
    local mobName = caster:getName()

    if caster:isMob() and mobName == 'Elatha' then
        local params = {}
        params.ecosystem = xi.ecosystem.ARCANA
        params.effect = xi.effect.FROST
        params.attribute = xi.mod.INT
        params.skillType = xi.skill.BLUE_MAGIC

        local tick = 3
        local duration = math.random(15, 30)
        local agiDown = utils.clamp(caster:getMainLvl() / 2, 0, 49)
        local dot = utils.clamp(math.floor((agiDown - 3) / 2), 0, 23)

        if target:getStatusEffect(xi.effect.CHOKE) ~= nil then
            target:delStatusEffect(xi.effect.CHOKE)
        end

        target:addStatusEffect(params.effect, dot, tick, duration)
        local randomizedDamage = math.random(125, 225)

        return randomizedDamage
    else
        return super(caster, target, spell)
    end
end)

return m
