-----------------------------------
-- Fomor Kings
-- Area: Garlaige Citadel [S]
-- Mob: Buarainech
-- Author: GM Hax
-- Features:
-- weak to earth, high meva / sdt to all other elements
-- 30 min rage timer
-- idle despawn will set once damage is started, fast depop
-- drawn in alliance on a cooldown, trigger is target greater than melee range
-- enmity decay every 30-45 seconds
-- large enmity vs pet masters on pet atk commands
-- enchanced enmity on physical damage taken / ws used vs, on a 10s recast
-- level up on offensive job ability use, locked behind a cooldown
-- level up on enfeebling magic use, locked behind a cooldown
-- casting any magic against it will trigger a magic reflect with a thunder 4, locked behind a cooldown
-- polearm ws bonus, 50% chance to use a secondary ws after using raiden thrust, penta thrust, or impulse drive
-- stun spell is aoe
-- spirit surge job special, acc/atk/def/haste boost and encurse while active. 60s duration
-----------------------------------
require('modules/module_utils')
require('scripts/globals/hunts')
require('scripts/mixins/fomor_hate')
require('scripts/mixins/rage')
-----------------------------------
local m = Module:new('fomor_buarainech')

local modulePath = 'xi.zones.Garlaige_Citadel_[S].mobs.Buarainech'

xi.module.ensureTable('xi.zones.Garlaige_Citadel_[S].mobs.Buarainech')

local jobAbilities = set {
    xi.jobAbility.PROVOKE,
    xi.jobAbility.STEAL,
    xi.jobAbility.SHIELD_BASH,
    xi.jobAbility.JUMP,
    xi.jobAbility.HIGH_JUMP,
    xi.jobAbility.WEAPON_BASH,
    xi.jobAbility.CHI_BLAST,
    xi.jobAbility.TOMAHAWK,
    xi.jobAbility.BLADE_BASH,
    xi.jobAbility.ANGON,
    xi.jobAbility.QUICKSTEP,
    xi.jobAbility.BOXSTEP,
    xi.jobAbility.STUTTER_STEP,
    xi.jobAbility.FEATHER_STEP,
}

local petAbilities = set {
    xi.jobAbility.FIGHT,
    xi.jobAbility.ASSAULT,
    xi.jobAbility.DEPLOY,
}

local spawnPos = { x = 121.450, y = 7.000, z = -121.820, rotation = 64 }

local function canPerformAction(mob)
    local act = mob:getCurrentAction()
    local isBusy = act == xi.act.MOBABILITY_START
        or act == xi.act.MOBABILITY_USING
        or act == xi.act.MOBABILITY_FINISH
        or act == xi.act.MAGIC_CASTING
        or act == xi.act.MAGIC_START
        or act == xi.act.MAGIC_FINISH

    local isActionQueueEmpty = mob:actionQueueEmpty()
    local isAlive = mob:isAlive()
    local canAct = isAlive and isActionQueueEmpty and not isBusy

    return canAct
end

local function drawInController(mob, target)
    local drawInRecast = mob:getLocalVar('drawInRecast')
    mob:setMobMod(xi.mobMod.DRAW_IN, 2)
    mob:resetEnmity(target)
    mob:setLocalVar('drawInRecast', os.time() + math.random(5, 10))
    mob:timer(4000, function(mobArg)
        mobArg:addTP(3000)
        mobArg:setMobMod(xi.mobMod.DRAW_IN, 0)
    end)
end

local function levelUp(mob)
    local currentTime = os.time()
    mob:injectActionPacket(mob:getID(), 4, 5000, 0, 0, 0, 0, 0)
    mob:setLocalVar('levelUpRecast', currentTime + math.random(15, 45))
    mob:addMod(xi.mod.ATT, 25)
    mob:addMod(xi.mod.DEF, 25)
    mob:addMod(xi.mod.HP, 5000)
    mob:addMod(xi.mod.REGEN, 5)
    mob:updateHealth()
    mob:setHP(mob:getMaxHP())
end

local function enmityDecay(mob, target)
    mob:lowerEnmity(target, 75)  -- 75% enmity reduction
end

local function spiritSurge(mob)
    mob:setLocalVar("jobSpecial", 2)
    mob:messageBasic(xi.msg.basic.USES_JA, xi.jobAbility.SPIRIT_SURGE)
    mob:useMobAbility(624) -- dust cloud / job special animation
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:addMod(xi.mod.ATTP, 25)
    mob:addMod(xi.mod.DEFP, 25)
    mob:addMod(xi.mod.HASTE_ABILITY, 2500)
    mob:addStatusEffect(xi.effect.ACCURACY_BOOST, 20, 0, 60)
end

local function removeSpiritSurge(mob)
    mob:delMod(xi.mod.HASTE_ABILITY, 2500)
    mob:delMod(xi.mod.ATTP, 25)
    mob:delMod(xi.mod.DEFP, 25)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 0)
end

m:addOverride(modulePath .. '.onMobInitialize', function(mob)
    g_mixins.rage(mob)
end)

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    mob:setMod(xi.mod.FIRE_MEVA, 300)  -- weak to earth. high meva / sdt to all other elements.
    mob:setMod(xi.mod.ICE_MEVA, 300)
    mob:setMod(xi.mod.WIND_MEVA, 300)
    mob:setMod(xi.mod.THUNDER_MEVA, 300)
    mob:setMod(xi.mod.WATER_MEVA, 300)
    mob:setMod(xi.mod.LIGHT_MEVA, 300)
    mob:setMod(xi.mod.DARK_MEVA, 300)
    mob:setMod(xi.mod.FIRE_SDT, 300)
    mob:setMod(xi.mod.ICE_SDT, 300)
    mob:setMod(xi.mod.WIND_SDT, 300)
    mob:setMod(xi.mod.THUNDER_SDT, 300)
    mob:setMod(xi.mod.WATER_SDT, 300)
    mob:setMod(xi.mod.LIGHT_SDT, 300)
    mob:setMod(xi.mod.DARK_SDT, 300)
    mob:setMod(xi.mod.REGEN, 15)  -- ini for this
    mob:addImmunity(xi.immunity.GRAVITY)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.PETRIFY)
    mob:addImmunity(xi.immunity.TERROR)
    mob:addMod(xi.mod.ACC, 46)  -- 400 total acc
    mob:addMod(xi.mod.ATT, 95)  -- 500 total atk
    mob:addMod(xi.mod.DEF, 153) -- 500 total def
    mob:addMod(xi.mod.EVA, 35)  -- 375 total eva
    mob:addMod(xi.mod.DEX, 14)  -- 90 total dex
    mob:addMod(xi.mod.VIT, 7)   -- 85 total vit
    mob:addMod(xi.mod.AGI, 10)  -- 90 total agi
    mob:addMod(xi.mod.MND, 14)  -- 90 total mnd
    mob:addMod(xi.mod.INT, -5)  -- 80 total int
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.UFASTCAST, 35)
    mob:addMod(xi.mod.REGAIN, 20)
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    mob:setLocalVar('levelUpRecast', os.time() + math.random(5, 15))  -- ini setup
    mob:setLocalVar('enmityDecayTime', os.time() + 30)  -- ini setup
    mob:addListener('ABILITY_TAKE', 'BUARAINECH_PLAYER_JA_USED', function(mobArg, player, ability, action)
        local currentTime = os.time()
        local levelUpRecast = mobArg:getLocalVar('levelUpRecast')

        if canPerformAction(mobArg) then
            if currentTime > levelUpRecast then
                if jobAbilities[ability:getID()] then
                    mobArg:queue(0, function(mobArg)
                        levelUp(mobArg)
                    end)
                end
            end
        end

        if petAbilities[ability:getID()] then
            mobArg:addEnmity(player, 0, 1800)
        end
    end)
    mob:addListener('MAGIC_TAKE', 'BUARAINECH_MAGIC_TAKE', function(target, caster, spell)
        local currentTime = os.time()
        local magicReflectRecast = target:getLocalVar('magicReflectRecast')

        if spell:tookEffect() and (caster:isPC() or caster:isPet()) then
            if currentTime > magicReflectRecast then
                target:setLocalVar('magicReflect', 1)
                target:setLocalVar('magicReflectRecast', currentTime + math.random(15, 30))
            end
            if spell:getSkillType() == xi.skill.ENFEEBLING_MAGIC then
                if canPerformAction(target) then
                    if currentTime > target:getLocalVar('levelUpRecast') then
                        target:queue(0, function(targetArg)
                            levelUp(targetArg)
                        end)
                    end
                end
            end
        end
    end)
    mob:addListener('EFFECT_LOSE', 'BUARAINECH_SP_END', function(mob, effect)
        if effect:getEffectType() == xi.effect.ACCURACY_BOOST then
            removeSpiritSurge(mob)
        end
    end)
    mob:addListener('TAKE_DAMAGE', 'BUARAINECH_TAKE_DAMAGE', function(mobArg, amount, attacker, attackType, damageType)
        local currentTime = os.time()
        local lastTakeDamageTime = mobArg:getLocalVar('lastTakeDamageTime')

        if currentTime > lastTakeDamageTime + 10 then
            lastTakeDamageTime = currentTime

            if attackType == xi.attackType.PHYSICAL then
                mobArg:addEnmity(attacker, 500, 500)
            end
        end
    end)
    mob:addListener('WEAPONSKILL_TAKE', 'BUARAINECH_WEAPONSKILL_TAKE', function(targetArg, attacker, skillid, tp, action)
        local currentTime = os.time()
        local lastWeaponSkillTakeTime = targetArg:getLocalVar('lastWeaponSkillTakeTime')

        if currentTime > lastWeaponSkillTakeTime + 10 then
            lastWeaponSkillTakeTime = currentTime

            targetArg:addEnmity(attacker, 500, 500)
        end
    end)
    mob:addListener('WEAPONSKILL_STATE_EXIT', 'BUARAINECH_BONUS_WS', function(mobArg, skillID)
        local raidenThrust = xi.weaponskill.RAIDEN_THRUST
        local pentaThrust = xi.weaponskill.PENTA_THRUST
        local impulseDrive = xi.weaponskill.IMPULSE_DRIVE
        local repeatSkill = math.random() < 0.5  -- 50% chance
        local currentTime = os.time()
        local wsBonusRecast = mobArg:getLocalVar('wsBonusRecast') or 0

        if (skillID == raidenThrust or skillID == pentaThrust or skillID == impulseDrive) and currentTime > wsBonusRecast then
            if repeatSkill then
                mobArg:setLocalVar('wsBonusRecast', currentTime + 60)
                mobArg:useMobAbility(skillID)
            end
        end
    end)
end)

m:addOverride(modulePath .. '.onAdditionalEffect', function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.CURSE, { chance = 100, power = math.random(16, 55)})
end)

m:addOverride(modulePath .. '.onMobFight', function(mob, target)
    local time = os.time()
    local drawInRecast = mob:getLocalVar('drawInRecast')
    local magicReflect = mob:getLocalVar('magicReflect')
    local magicReflectRecast = mob:getLocalVar('magicReflectRecast')
    local enmityDecayTime = mob:getLocalVar('enmityDecayTime')
    local lifePercent = mob:getHPP()
    local jobSpecial = mob:getLocalVar("jobSpecial")
    local idleDespawnTrigger = mob:getLocalVar("idleDespawnTrigger")
    local lastDrawInCheck = mob:getLocalVar('lastDrawInCheck')

    if lifePercent < 99 and idleDespawnTrigger == 0 then
        mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 10)
        mob:setLocalVar("idleDespawnTrigger", 1)
    end

    if lifePercent <= 51 and jobSpecial == 0 then
        mob:setLocalVar("jobSpecial", 1)
    end

    if jobSpecial == 1 then
        spiritSurge(mob)
    end

    if time > lastDrawInCheck + 2 then
        mob:setLocalVar('lastDrawInCheck', time)

        if target then
            local distance = mob:checkDistance(target)
            if distance and distance > 5 and time > drawInRecast then
                drawInController(mob, target)
            end
        end
    end

    if magicReflect == 1 then
        if canPerformAction(mob) then
            mob:castSpell(xi.magic.spell.THUNDER_IV, target)
            mob:setLocalVar('magicReflect', 0)
        end
    end
    if time > enmityDecayTime then
        enmityDecay(mob, target)
        mob:setLocalVar('enmityDecayTime', time + math.random(30, 45))
    end
end)

m:addOverride(modulePath .. '.onSpellPrecast', function(mob, spell)
    if spell:getID() == xi.magic.spell.STUN then
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL)
        spell:setRadius(18)
    end
end)

m:addOverride(modulePath .. '.onMobDeath', function(mob, player, optParams)
    xi.hunts.checkHunt(mob, player, 534)
    player:setTitle(xi.title.BUARAINECH_EXORCIST)
end)

m:addOverride(modulePath .. '.onMobDespawn', function(mob)
    mob:resetLocalVars()
    mob:removeListener('BUARAINECH_PLAYER_JA_USED')
    mob:removeListener('BUARAINECH_MAGIC_TAKE')
    mob:removeListener('BUARAINECH_SP_END')
    mob:removeListener('BUARAINECH_TAKE_DAMAGE')
    mob:removeListener('BUARAINECH_WEAPONSKILL_TAKE')
    mob:removeListener('BUARAINECH_BONUS_WS')
end)

m:addOverride('xi.actions.spells.blue.blitzstrahl.onSpellCast', function(caster, target, spell)
    local mobName = caster:getName()

    if caster:isMob() and mobName == 'Buarainech' then
        local params = {}
        params.ecosystem = xi.ecosystem.ARCANA
        params.attackType = xi.damageType.ELEMENTAL
        params.damageType = xi.damageType.THUNDER
        params.attribute = xi.mod.INT
        params.multiplier = 1.5625
        params.tMultiplier = 1.0
        params.duppercap = 61
        params.str_wsc = 0.0
        params.dex_wsc = 0.0
        params.vit_wsc = 0.0
        params.agi_wsc = 0.0
        params.int_wsc = 0.3
        params.mnd_wsc = 0.1
        params.chr_wsc = 0.0

        local damage = xi.spells.blue.useMagicalSpell(caster, target, spell, params)
        local randomizedDamage = math.random(125, 225)
        local stunDuration = math.random(5, 10)
        target:addStatusEffect(xi.effect.STUN, 1, 0, stunDuration)

        return randomizedDamage
    else
        return super(caster, target, spell)
    end
end)

m:addOverride('xi.actions.spells.blue.mind_blast.onSpellCast', function(caster, target, spell)
    local mobName = caster:getName()

    if caster:isMob() and mobName == 'Buarainech' then
        local params = {}
        params.ecosystem = xi.ecosystem.DEMON
        params.attackType = xi.attackType.MAGICAL
        params.damageType = xi.damageType.THUNDER
        params.attribute = xi.mod.MND
        params.multiplier = 2.05
        params.azureBonus = 0.5
        params.tMultiplier = 1.5
        params.duppercap = 69
        params.str_wsc = 0.0
        params.dex_wsc = 0.0
        params.vit_wsc = 0.0
        params.agi_wsc = 0.0
        params.int_wsc = 0.0
        params.mnd_wsc = 0.3
        params.chr_wsc = 0.0

        local damage = xi.spells.blue.useMagicalSpell(caster, target, spell, params)
        local randomizedDamage = math.random(125, 225)
        local paralysisDuration = math.random(5, 10)
        target:addStatusEffect(xi.effect.PARALYSIS, 20, 0, paralysisDuration)

        return randomizedDamage
    else
        return super(caster, target, spell)
    end
end)

return m
