-----------------------------------
-- CatsEyeXI
-- Area: Lufaise_Meadows
-- Mob: Flockbock
-----------------------------------
require('modules/module_utils')
require('scripts/mixins/rage')
-----------------------------------
local m = Module:new('nm_flockbock')

local modulePath = 'xi.zones.Lufaise_Meadows.mobs.Flockbock'

m:addOverride(modulePath .. '.onMobInitialize', function(mob)
    -- Has enhanced double attack.
    -- TODO: Exact STP value needs to be researched further
    mob:setMod(xi.mod.DOUBLE_ATTACK, 50)
    mob:addMod(xi.mod.STORETP,       50)
end)

m:addOverride(modulePath .. '.onMobSpawn', function(mob)
    local petribreath = 269

    -- Petribreath resets hate on use
    mob:addListener('WEAPONSKILL_USE', 'PETRIBREATH_HATE_RESET', function(mobArg, target, wsid, tp, action)
        if wsid == petribreath then
            mob:resetEnmity(target)
        end
    end)

    mob:setLocalVar('[rage]timer', 3600) -- 60 minutes
end)

-- TODO: Mob's movement speed is increased while chasing target.
-- It's tricky to emulate this exact mechanic, because on retail 'chase'
-- is triggered not only while the mob engaged, but also when target is out of range.
m:addOverride(modulePath .. '.onMobEngage', function(mob)
    mob:setSpeed(100)
end)

m:addOverride(modulePath .. '.onMobDisengage', function(mob, target)
    mob:setSpeed(40)
end)

m:addOverride(modulePath .. '.onMobDespawn', function(mob)
    UpdateNMSpawnPoint(mob:getID())
    mob:setRespawnTime(math.random(3600, 7200)) -- 1-2 hours
end)

return m
