-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Xarcabard
--  Mob: Marquis Caim
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_marquis_caim")

xi.module.ensureTable("xi.zones.Dynamis-Xarcabard.mobs.Marquis_Caim")

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Marquis_Caim.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMobMod(xi.mobMod.MULTI_HIT, 1)
    mob:setSpellList(968)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Marquis_Caim.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENDARK, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Marquis_Caim.onMobSpawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)

    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, 5) --  450 total atk
    mob:addMod(xi.mod.DEF, 65) -- 450 total def
    mob:addMod(xi.mod.EVA, 68) -- 400 total eva
    pet:setSpawn(mob:getXPos(), mob:getYPos(), mob:getZPos()-3, mob:getRotPos())
    SpawnMob(pet:getID())
    pet:updateEnmity(mob:getTarget())
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.FAMILIAR, hpp = 95},
            {id = xi.jsa.FAMILIAR, hpp = 75},
            {id = xi.jsa.FAMILIAR, hpp = 50},
            {id = xi.jsa.FAMILIAR, hpp = 25},
            {id = xi.jsa.MIJIN_GAKURE, hpp = math.random(50, 55), cooldown = math.random(90, 120)},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Marquis_Caim.onMobFight", function(mob, target)
    local pet         = GetMobByID(mob:getID() + 1)
    local lifePercent = mob:getHPP()
    local bstSP       = mob:getLocalVar("bstSP")
    local recast      = mob:getLocalVar("recast")

    local function buffPet(mob)
        pet:setHP(pet:getMaxHP())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("bstSP", mob:getLocalVar("bstSP") + 1)
    end

    local function callPet(mob)
        pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
        SpawnMob(pet:getID())
        pet:updateEnmity(mob:getTarget())
        pet:setTP(3000)
        mob:setTP(3000)
        mob:setLocalVar("bstSP", mob:getLocalVar("bstSP") + 1)
    end
    -- check for pet before bst SP, spawn if needed and buff.
    if lifePercent < 97 and pet:isAlive() and bstSP == 0 then
        buffPet(mob)
    elseif lifePercent < 97 and pet:isDead() and bstSP == 0 then
        callPet(mob)
    elseif lifePercent < 77 and pet:isAlive() and bstSP == 1 then
        buffPet(mob)
    elseif lifePercent < 77 and pet:isDead() and bstSP == 1 then
        callPet(mob)
    elseif lifePercent < 52 and pet:isAlive() and bstSP == 2 then
        buffPet(mob)
    elseif lifePercent < 52 and pet:isDead() and bstSP == 2 then
        callPet(mob)
    elseif lifePercent < 27 and pet:isAlive() and bstSP == 3 then
        buffPet(mob)
    elseif lifePercent < 27 and pet:isDead() and bstSP == 3 then
        callPet(mob)
    end

    local isBusy = false
    local act    = mob:getCurrentAction()

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    if mob:actionQueueEmpty() and not isBusy then
        if os.time() > recast then
            if mob:actionQueueEmpty() and not isBusy then
                if not mob:hasStatusEffect(xi.effect.COPY_IMAGE) then
                    if math.random(1, 2) == 1 then
                        mob:castSpell(xi.magic.spell.UTSUSEMI_SAN, mob)
                        mob:setLocalVar("recast", os.time() + 12)
                    else
                        mob:castSpell(xi.magic.spell.UTSUSEMI_NI, mob)
                        mob:setLocalVar("recast", os.time() + 15)
                    end
                end
            end
        end
    end

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3000
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Marquis_Caim.onMobDespawn", function(mob)
    local pet = GetMobByID(mob:getID() + 1)
    DespawnMob(pet:getID())
    mob:resetLocalVars()
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Marquis_Caim.onMobDeath", function(mob, player, optParams)
    local pet = GetMobByID(mob:getID() + 1)
    DespawnMob(pet:getID())
    mob:resetLocalVars()
end)

return m
