-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Xarcabard
--  Mob: Duke Haures
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_duke_haures")

xi.module.ensureTable("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures")

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setSpellList(973)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENDARK, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, 6) -- 450 total atk
    mob:addMod(xi.mod.DEF, 68) -- 450 total def
    mob:addMod(xi.mod.EVA, 72) -- 400 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(60, 120),
        specials =
        {
            {id = xi.jsa.CHAINSPELL, hpp = math.random(90, 98), cooldown = 0},
            {id = xi.jsa.SOUL_VOICE, hpp = math.random(80, 90), cooldown = 0 },
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures.onMobFight", function(mob, target)
    mob:addListener("EFFECT_GAIN", "chainStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            if math.random(1, 2) > 1 then
                mob:setSpellList(972) -- nukes
            else
                mob:setSpellList(971) -- buffs
            end
        end
    end)

    mob:addListener("EFFECT_LOSE", "chainEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:setSpellList(973) -- enfeebles
        end
    end)

    mob:addListener("EFFECT_GAIN", "voiceStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(978)
            mob:setMod(xi.mod.UFASTCAST, 50)
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 20)
        end
    end)

    mob:addListener("EFFECT_LOSE", "voiceEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.SOUL_VOICE then
            mob:setSpellList(973) -- enfeebles
            mob:setMod(xi.mod.UFASTCAST, 25)
            mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3000
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures.onSpellPrecast", function(mob, spell)
    if spell:getID() == 462 or -- magic_finale
        spell:getID() == 376 or -- horde_lullaby
        spell:getID() == 463 or -- foe_lullaby
        spell:getID() == 423 -- massacre_elegy
    then
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL)
        spell:setRadius(30)
    end
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("voiceStart")
    mob:removeListener("voiceEnd")
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Duke_Haures.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("voiceStart")
    mob:removeListener("voiceEnd")
end)

return m
