-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Xarcabard
--  Mob: Baron Avnas
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_baron_avnas")

xi.module.ensureTable("xi.zones.Dynamis-Xarcabard.mobs.Baron_Avnas")

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Baron_Avnas.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DARK_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Baron_Avnas.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENDARK, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Baron_Avnas.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.ATT, -71) -- 450 total atk
    mob:addMod(xi.mod.DEF, 40)  -- 425 total def
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(90, 120),
        specials =
        {
            {id = xi.jsa.BLOOD_WEAPON, hpp = math.random(92, 98), cooldown = 0},
            {id = xi.jsa.PERFECT_DODGE, hpp = math.random(82, 88), cooldown = 0},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Baron_Avnas.onMobFight", function(mob, target)
    local crit   = mob:getLocalVar("crit")
    local triple = mob:getLocalVar("triple")

    mob:addListener("EFFECT_GAIN", "drkStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.BLOOD_WEAPON then
            mob:setMobMod(xi.mobMod.MULTI_HIT, 5)
            mob:addStatusEffect(xi.effect.LAST_RESORT, 1, 0, 0)
            mob:setMagicCastingEnabled(false)
            mob:setMobAbilityEnabled(false)
        end
    end)

    mob:addListener("EFFECT_LOSE", "drkEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.BLOOD_WEAPON then
            mob:setMobMod(xi.mobMod.MULTI_HIT, 0)
            mob:delStatusEffect(xi.effect.LAST_RESORT)
            mob:setMagicCastingEnabled(true)
            mob:setMobAbilityEnabled(true)
        end
    end)

    mob:addListener("EFFECT_GAIN", "dodgeStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.PERFECT_DODGE then
            if math.random(1, 2) > 1 then
                mob:setMod(xi.mod.CRITHITRATE, 50)
                mob:setLocalVar("crit", mob:getLocalVar("crit") + 1)
            else
                mob:setMod(xi.mod.TRIPLE_ATTACK, 10)
                mob:setLocalVar("triple", mob:getLocalVar("triple") + 1)
            end
            mob:setTP(3000)
        end
    end)

    mob:addListener("EFFECT_LOSE", "dodgeEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.PERFECT_DODGE then
            if crit == 1 then
                mob:setMod(xi.mod.CRITHITRATE, -50)
                mob:setLocalVar("crit", 0)
            elseif triple == 1 then
                mob:setMod(xi.mod.TRIPLE_ATTACK, 0)
                mob:setLocalVar("triple", 0)
            end
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3000
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Baron_Avnas.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("dodgeStart")
    mob:removeListener("dodgeEnd")
    mob:removeListener("drkStart")
    mob:removeListener("drkEnd")
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Baron_Avnas.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("dodgeStart")
    mob:removeListener("dodgeEnd")
    mob:removeListener("drkStart")
    mob:removeListener("drkEnd")
end)

return m
