-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Xarcabard
-- Arch_Dynamis_Lord_2
-- File for clones
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
-----------------------------------

local m = Module:new("dyna_2_0_arch_dynamis_lord_2")

xi.module.ensureTable("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord_2")

-- Clone IDs to despawn.
local despawnMobTable =
{
    17330192,
    17330193,
    17330194,
    17330195,
}
m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord_2.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 10)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord_2.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 104) -- 500 total acc
    mob:addMod(xi.mod.ATT, 71) -- 600 total atk
    mob:addMod(xi.mod.DEF, 128) -- 600 total def
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(90, 120),
        specials =
        {
            {id = xi.jsa.BLOOD_WEAPON, cooldown = 0, hpp = 100},
            {id = xi.jsa.CHAINSPELL, cooldown = 0, hpp = 100},
            {id = xi.jsa.HUNDRED_FISTS, cooldown = 0, hpp = 100},
            {id = xi.jsa.MIGHTY_STRIKES, cooldown = 0, hpp = 100},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord_2.onMobDeath", function(mob, player, optParams)
    local mobId = mob:getID()
    local realID = GetServerVariable('[ADL]hasDrops')
    if mobId == realID then
        for _, despawnMob in ipairs(despawnMobTable) do
            if despawnMob ~= realID then  -- Don't despawn mob with loot.
                DespawnMob(despawnMob)
            end
        end
        player:addTitle(xi.title.DEVOURER_OF_SHADOWS)
        SetServerVariable('[ADL]cloneTime', 0)
        SetServerVariable('[ADL]storedHP', 0)
        SetServerVariable('[ADL]hasDrops', 0)
        SetServerVariable('[ADL]cloneCount', 0)
    end
end)

return m
