-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Xarcabard
-- Arch_Dynamis_Lord
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
-----------------------------------

local m = Module:new("dyna_2_0_arch_dynamis_lord")

xi.module.ensureTable("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord")

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.BIND)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 50)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 10)
    mob:setUnkillable(true)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 104) -- 500 total acc
    mob:addMod(xi.mod.ATT, 71) -- 600 total atk
    mob:addMod(xi.mod.DEF, 128) -- 600 total def
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes
    SetServerVariable('[ADL]hasDrops', mob:getID())
    xi.mix.jobSpecial.config(mob, {
        between = math.random(90, 120),
        specials = {
            {id = xi.jsa.BLOOD_WEAPON, cooldown = 0, hpp = 100},
            {id = xi.jsa.CHAINSPELL, cooldown = 0, hpp = 100},
            {id = xi.jsa.HUNDRED_FISTS, cooldown = 0, hpp = 100},
            {id = xi.jsa.MIGHTY_STRIKES, cooldown = 0, hpp = 100},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord.onMobEngage", function(mob, target)
    SetServerVariable('[ADL]cloneTime', os.time() + math.random(90, 120)) -- Adjust here for balance. Timer for cloneAction call.
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord.onMobFight", function(mob, target)
    local cloneTime = GetServerVariable('[ADL]cloneTime')
    local isBusy = false
    local lifePercent = mob:getHPP()
    local act = mob:getCurrentAction()
	local realID = GetServerVariable('[ADL]hasDrops')
    local realADL = GetMobByID(realID)
    local mobId = mob:getID()

    if
        act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH
    then
        isBusy = true
    end

    -- Calculate the clone count based on HP percentage.
    if lifePercent <= 100 and lifePercent >= 76 then
        SetServerVariable('[ADL]cloneCount', 1)
    elseif lifePercent <= 75 and lifePercent >= 51 then
        SetServerVariable('[ADL]cloneCount', 2)
    elseif lifePercent <= 50 and lifePercent >= 26 then
        SetServerVariable('[ADL]cloneCount', 3)
    elseif lifePercent <= 25 and lifePercent >= 1 then
        SetServerVariable('[ADL]cloneCount', 4)
    else
        SetServerVariable('[ADL]cloneCount', 0) -- Reset clone count if not in specified ranges.
    end

    local function cloneAction(mob)
        if mob:actionQueueEmpty() and not isBusy then
            SetServerVariable('[ADL]storedHP', mob:getHP()) -- Store the HP.
            local cloneCount = GetServerVariable('[ADL]cloneCount')
            local hasDrops = math.random(0, cloneCount) -- Randomly choose which mob has loot.
            for i = mobId, mobId + cloneCount do
                DespawnMob(i)
            end

            mob:timer(7000, function(mobArg)
                for i = mobId, mobId + cloneCount do
                    local cloneHP = GetServerVariable('[ADL]storedHP')
                    local cloneMob = SpawnMob(i)
                    cloneMob:updateEnmity(target)
                    cloneMob:setHP(cloneHP)
                    cloneMob:updateHealth()

                    if i == mobId + hasDrops then
					    -- (!) TODO: Add the correct drop list ID below.
                        cloneMob:setDropID(151) -- Mob with loot
                        SetServerVariable('[ADL]hasDrops', i) -- Store the mob ID of the mob with loot.
                    else
                        cloneMob:setDropID(0) -- Mobs without loot
                    end

                    SetServerVariable('[ADL]cloneTime', os.time() + math.random(90, 120)) -- Adjust here for balance. Timer for cloneAction call.
                end
            end)
        end
    end

    if not realADL or not realADL:isAlive() then
        DespawnMob(mob:getID()) -- Despawn the main mob.
    else
        if os.time() > cloneTime then
            cloneAction(mob)
        end
    end

    if mobId == realID then
        mob:setUnkillable(false)
    else
        mob:setUnkillable(true)
    end
end)

m:addOverride("xi.zones.Dynamis-Xarcabard.mobs.Arch_Dynamis_Lord.onMobDeath", function(mob, player, optParams)
    local mobId = mob:getID()
    local cloneCount = GetServerVariable('[ADL]cloneCount')
    for i = mobId + 1, mobId + cloneCount do
        DespawnMob(i)
    end
    player:addTitle(xi.title.DEVOURER_OF_SHADOWS)
    SetServerVariable('[ADL]cloneTime', 0)
    SetServerVariable('[ADL]storedHP', 0)
    SetServerVariable('[ADL]hasDrops', 0)
    SetServerVariable('[ADL]cloneCount', 0)
end)

return m
