-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Windurst
--  Mob: Xuu Bhoqa the Enigma
-- !Spawnmob 17543464
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
require("scripts/mixins/remove_doom")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_xuu_bhoqa_the_enigma")

xi.module.ensureTable("xi.zones.Dynamis-Windurst.mobs.Xuu_Bhoqa_the_Enigma")

local elementalDayAvatar =
{
    [xi.element.FIRE   ] = { 793, 913 }, -- ifrit     inferno
    [xi.element.ICE    ] = { 797, 917 }, -- shiva     diamond dust
    [xi.element.WIND   ] = { 796, 916 }, -- garuda    aerial blast
    [xi.element.EARTH  ] = { 794, 914 }, -- titan     earthen fury
    [xi.element.THUNDER] = { 798, 918 }, -- ramuh     judgment bolt
    [xi.element.WATER  ] = { 795, 915 }, -- leviathan tidal wave
    [xi.element.LIGHT  ] = { 791, 919 }, -- carbuncle searing light
    [xi.element.DARK   ] = { 792, 839 }, -- fenrir    howling moon
}

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Xuu_Bhoqa_the_Enigma.onMobInitialize", function(mob)
    g_mixins.clear_doom(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 50)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 50)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.WIND_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMobMod(xi.mobMod.MULTI_HIT, 1)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Xuu_Bhoqa_the_Enigma.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENAERO, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Xuu_Bhoqa_the_Enigma.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, -7) -- 425 total atk
    mob:addMod(xi.mod.DEF, 68) -- 450 total def
    mob:addMod(xi.mod.EVA, -39)-- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.PERFECT_DODGE, cooldown = math.random(90, 120), hpp = math.random(92, 98)},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Xuu_Bhoqa_the_Enigma.onMobFight", function(mob, target)
    local crit        = mob:getLocalVar("crit")
    local triple      = mob:getLocalVar("triple")
    local pet         = GetMobByID(mob:getID() + 1)
    local lifePercent = mob:getHPP()
    local smnSP       = mob:getLocalVar("smnSP")
    local petWS       = mob:getLocalVar("petWS")
    local skillId     = elementalDayAvatar[VanadielDayElement()][2]

    local function callPet(mob)
        mob:useMobAbility(624) -- Dust cloud
        pet:setModelId(elementalDayAvatar[VanadielDayElement()][1])
        pet:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos()-2, mob:getRotPos())
        SpawnMob(pet:getID())
        pet:updateEnmity(mob:getTarget())
        pet:hideName(false)
        pet:setUntargetable(true)
        pet:setUnkillable(true)
        pet:setAutoAttackEnabled(false)
        pet:setMagicCastingEnabled(false)
        pet:setHP(pet:getMaxHP())
        pet:setMod(xi.mod.STUNRES, 10000)
        pet:setMod(xi.mod.BLINDRES, 10000)
        pet:setMod(xi.mod.BINDRES, 10000)
        pet:setMod(xi.mod.GRAVITYRES, 10000)
        pet:setMod(xi.mod.SLEEPRES, 10000)
        pet:setMod(xi.mod.POISONRES, 10000)
        pet:setMod(xi.mod.PARALYZERES, 10000)
        pet:setMod(xi.mod.LULLABYRES, 10000)
        mob:setLocalVar("smnSP", mob:getLocalVar("smnSP") + 1)
        mob:setLocalVar("petWS", mob:getLocalVar("petWS") + 1)
    end
    -- astral flow logic
    if lifePercent < 96 and smnSP == 0 then
        callPet(mob)
    elseif lifePercent < 76 and smnSP == 1 then
        callPet(mob)
    elseif lifePercent < 51 and smnSP == 2 then
        callPet(mob)
    elseif lifePercent < 26 and smnSP == 3 then
        callPet(mob)
    end
    -- make pet use SP and despawn
    if petWS == 1 then
        pet:useMobAbility(skillId)
        mob:setLocalVar("petWS", 0)
        mob:timer(5000, function(mobArg)
            DespawnMob(mob:getID() + 1)
        end)
    end

    mob:addListener("EFFECT_GAIN", "dodgeStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.PERFECT_DODGE then
            if math.random(1, 2) > 1 then
                mob:setMod(xi.mod.CRITHITRATE, 50)
                mob:setLocalVar("crit", mob:getLocalVar("crit") + 1)
            else
                mob:setMod(xi.mod.TRIPLE_ATTACK, 10)
                mob:setLocalVar("triple", mob:getLocalVar("triple") + 1)
            end
            mob:setTP(3000)
        end
    end)

    mob:addListener("EFFECT_LOSE", "dodgeEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.PERFECT_DODGE then
            if crit == 1 then
                mob:setMod(xi.mod.CRITHITRATE, -50)
                mob:setLocalVar("crit", 0)
            elseif triple == 1 then
                mob:setMod(xi.mod.TRIPLE_ATTACK, 0)
                mob:setLocalVar("triple", 0)
            end
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Xuu_Bhoqa_the_Enigma.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("dodgeStart")
    mob:removeListener("dodgeEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Xuu_Bhoqa_the_Enigma.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("dodgeStart")
    mob:removeListener("dodgeEnd")
    mob:removeListener("shortProc")
end)

return m
