-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Windurst
--  Mob: Naa Yixo the Stillrage
-- !Spawnmob 17543467
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
require("scripts/mixins/remove_doom")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_naa_yixo_the_stillrage")

xi.module.ensureTable("xi.zones.Dynamis-Windurst.mobs.Naa_Yixo_the_Stillrage")

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Naa_Yixo_the_Stillrage.onMobInitialize", function(mob)
    g_mixins.clear_doom(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 50)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 50)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.WIND_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 20)
    mob:setSpellList(971)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Naa_Yixo_the_Stillrage.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENAERO, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Naa_Yixo_the_Stillrage.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, 9) -- 450 total atk
    mob:addMod(xi.mod.DEF, 65) -- 450 total def
    mob:addMod(xi.mod.EVA, 38)-- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        between = math.random(60, 120),
        specials =
        {
            {id = xi.jsa.CHAINSPELL, hpp = 100, cooldown = 0},
            {
                id = xi.jsa.MEIKYO_SHISUI,
                duration = 8,
                cooldown = 0,
                hpp = math.random(92, 98),
                begCode = function(mobArg)
                    mob:setMagicCastingEnabled(false)
                end
            },
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Naa_Yixo_the_Stillrage.onMobFight", function(mob, target)
    local wsOrder = mob:getLocalVar("wsOrder")

    if mob:hasStatusEffect(xi.effect.MEIKYO_SHISUI) then
        if mob:getLocalVar("wsOrder") == 0 then
            mob:useMobAbility(764) -- yagudo howl
            mob:setLocalVar("wsOrder", 1)
            mob:setTP(3000)
        elseif mob:getLocalVar("wsOrder") == 1 then
            mob:useMobAbility(620) -- sweep
            mob:setLocalVar("wsOrder", 2)
            mob:setTP(2000)
        elseif mob:getLocalVar("wsOrder") == 2 then
            mob:useMobAbility(620) -- sweep
            mob:setLocalVar("wsOrder", 3)
            mob:setTP(1000)
        elseif mob:getLocalVar("wsOrder") == 3 then
            mob:useMobAbility(620) -- sweep
            mob:setLocalVar("wsOrder", 4)
            mob:setTP(0)
        elseif mob:getLocalVar("wsOrder") == 4 then
            mob:setLocalVar("wsOrder", 5)
        end
    end

    mob:addListener("EFFECT_LOSE", "samEnd", function(mob, effect)

        if effect:getEffectType() == xi.effect.MEIKYO_SHISUI then
            mob:setLocalVar("wsOrder", 0)
            mob:setMagicCastingEnabled(true)
        end
    end)

    mob:addListener("EFFECT_GAIN", "chainStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            if math.random(1, 2) > 1 then
                mob:setSpellList(972) -- nukes
            else
                mob:setSpellList(971) -- buffs
            end
        end
    end)

    mob:addListener("EFFECT_LOSE", "chainEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.CHAINSPELL then
            mob:setSpellList(973) -- enfeebles
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Naa_Yixo_the_Stillrage.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("samEnd")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Naa_Yixo_the_Stillrage.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("chainStart")
    mob:removeListener("chainEnd")
    mob:removeListener("samEnd")
    mob:removeListener("shortProc")
end)

return m
