-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Windurst
--  Mob: Fuu Tzapo the Blessed
-- !Spawnmob 17543466
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
require("scripts/mixins/remove_doom")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_fuu_tzapo_the_blessed")

xi.module.ensureTable("xi.zones.Dynamis-Windurst.mobs.Fuu_Tzapo_the_Blessed")

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Fuu_Tzapo_the_Blessed.onMobInitialize", function(mob)
    g_mixins.clear_doom(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 50)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 50)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:setMod(xi.mod.WIND_ABSORB, 100)
    mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setSpellList(970)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Fuu_Tzapo_the_Blessed.onAdditionalEffect", function(mob, target, damage)
    return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENLIGHT, {power = math.random(16, 55)})
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Fuu_Tzapo_the_Blessed.onMobSpawn", function(mob)
    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:addMod(xi.mod.ACC, 39)  -- 400 total acc
    mob:addMod(xi.mod.ATT, -55) -- 425 total atk
    mob:addMod(xi.mod.DEF, 28)  -- 450 total def
    mob:addMod(xi.mod.EVA, 65)  -- 375 total eva
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    xi.mix.jobSpecial.config(mob, {
        specials =
        {
            {id = xi.jsa.MIGHTY_STRIKES, cooldown = math.random(90, 120), hpp = math.random(92, 98)},
            {id = xi.jsa.BENEDICTION, hpp = 30,},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Fuu_Tzapo_the_Blessed.onMobFight", function(mob, target)
    local lifePercent = mob:getHPP()
    local phase = mob:getLocalVar("phase")

    if lifePercent < 11 and phase == 0 then
        mob:setLocalVar("phase", 1)
    end

    if phase == 1 then
        mob:setSpellList(969)
        mob:setMobMod(xi.mobMod.MAGIC_COOL, 15)
        mob:addMod(xi.mod.CURE_POTENCY, 50)
        mob:setLocalVar("phase", 2)
    end

    mob:addListener("EFFECT_GAIN", "warStart", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            mob:setMagicCastingEnabled(false)
            mob:addStatusEffect(xi.effect.RETALIATION, 1, 0, 0)
            mob:addStatusEffect(xi.effect.BLOOD_RAGE, 1, 0, 0)
            mob:useMobAbility(764) -- yagudo howl
            mob:setTP(3000)
            mob:useMobAbility(620) -- sweep
        end
    end)

    mob:addListener("EFFECT_LOSE", "warEnd", function(mob, effect)
        if effect:getEffectType() == xi.effect.MIGHTY_STRIKES then
            mob:setMagicCastingEnabled(true)
            mob:delStatusEffect(xi.effect.RETALIATION)
            mob:delStatusEffect(xi.effect.BLOOD_RAGE)
        end
    end)

    mob:addListener("EFFECT_GAIN", "shortProc", function(mob, effect)
        if effect:getEffectType() == xi.effect.TERROR then
            mob:timer(3000, function(mobArg)
                mob:delStatusEffect(xi.effect.TERROR)
            end)
        end
    end)

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3500
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Fuu_Tzapo_the_Blessed.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("warStart")
    mob:removeListener("warEnd")
    mob:removeListener("whmStart")
    mob:removeListener("shortProc")
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Fuu_Tzapo_the_Blessed.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
    mob:removeListener("warStart")
    mob:removeListener("warEnd")
    mob:removeListener("whmStart")
    mob:removeListener("shortProc")
end)

return m
