-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Windurst
-- Mob: Arch_Tzee_Xicu_Idol
-- !Spawnmob 17543469
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/job_special")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_arch_tzee_xicu_idol")

xi.module.ensureTable("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol")

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onMobInitialize", function(mob)
    g_mixins.job_special(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 150)
    mob:setMod(xi.mod.ICE_MEVA, 50)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 200)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 150)
    mob:setMod(xi.mod.ICE_SDT, 50)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 200)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:setMod(xi.mod.PIERCE_SDT, 300)
    mob:setMod(xi.mod.SLASH_SDT, 300)
    mob:setMod(xi.mod.IMPACT_SDT, 300)
    mob:setMod(xi.mod.HTH_SDT, 300)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.ATT, 20)
    mob:addStatusEffect(xi.effect.REFRESH, 150, 3, 0)
    mob:setMobMod(xi.mobMod.ADD_EFFECT, 1)
    mob:setMobMod(xi.mobMod.MAGIC_COOL, 35)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
    mob:setMod(xi.mod.MOVE_SPEED_STACKABLE, 75)
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onAdditionalEffect", function(mob, target, damage)
    local addDMG = mob:getLocalVar("addDMG")

    if addDMG == 1 then
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENFIRE, {power = math.random(16, 55)})
    elseif addDMG == 2 then
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENBLIZZARD, {power = math.random(16, 55)})
    elseif addDMG == 3 then
        mob:setLocalVar("addDMG", 0)
        return xi.mob.onAddEffect(mob, target, damage, xi.mob.ae.ENTHUNDER, {power = math.random(16, 55)})
    end
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onMobSpawn", function(mob)
    local startWS = mob:getLocalVar("startWS")
    -- Open each fight immediately with seismostomp
    mob:addListener("ENGAGE", "openWS", function(mob)
        mob:setTP(3000)
        mob:useMobAbility(1112) -- seismostomp
        mob:setLocalVar("startWS", 1)
    end)

    if startWS == 1 then
        mob:removeListener("openWS")
    end

    mob:setMod(xi.mod.UFASTCAST, 25)
    mob:setSpellList(967)

    -- Add mods for balancing here
    mob:addMod(xi.mod.ACC, 39) -- 400 total acc
    mob:addMod(xi.mod.ATT, 18) -- 450 total atk
    mob:addMod(xi.mod.DEF, 76) -- 450 total def
    mob:addMod(xi.mod.EVA, 26) -- 375 total eva
    mob:setLocalVar("[rage]timer", 1800) -- 30 minutes

    xi.mix.jobSpecial.config(mob, {
        specials = {
            {id = xi.jsa.MANAFONT, cooldown = math.random(150, 180), hpp = 95},
        },
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onMobEngage", function(mob, target)
    mob:setLocalVar("fightTIME", 0)
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onMobWeaponSkill", function(target, mob, skill)
    -- Each seismostomp is followed by a second seismostomp
    local extraWS = mob:getLocalVar("extraWS") or 0
    local extraWScounter = mob:getLocalVar("extraWScounter") or 0

    if skill:getID() == 1112 then -- seismostomp
        if extraWScounter == 0 and extraWS == 0 then
            extraWS = 1
            mob:setLocalVar("extraWS", extraWS)
        end

        extraWScounter = extraWScounter + 1
        mob:setLocalVar("extraWScounter", extraWScounter)

        if extraWScounter > extraWS then
            mob:setLocalVar("extraWScounter", 0)
            mob:setLocalVar("extraWS", 0)
        else
            local currentTime = os.time()
            local stompTime = mob:getLocalVar("stompTime") or currentTime + math.random(45, 90)

            if currentTime >= stompTime then
                mob:setLocalVar("stompTime", currentTime + math.random(45, 90))
                mob:timer(3000, function(mobArg)
                    mobArg:useMobAbility(1112) -- seismostomp
                end)
            end
        end
    end
end)


m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onMobFight", function(mob, target)
    local lifePercent = mob:getHPP()
    local phase = mob:getLocalVar("phase")
    local fightTIME = mob:getLocalVar("fightTIME")
    local intervalTIME = math.random(25, 60)
    local isBusy = false
    local act = mob:getCurrentAction()
    local MAGICphase = mob:getLocalVar("MAGICphase")
    local damage = math.random(10, 35)
    local deathRecast = mob:getLocalVar("deathRecast")

    local function fire()
        mob:delStatusEffect(xi.effect.SHOCK_SPIKES)
        mob:addStatusEffect(xi.effect.BLAZE_SPIKES, damage, 0, 0)
        mob:setLocalVar("addDMG", 1)
    end

    local function ice()
        mob:delStatusEffect(xi.effect.BLAZE_SPIKES)
        mob:addStatusEffect(xi.effect.ICE_SPIKES, damage, 0, 0)
        mob:setLocalVar("addDMG", 2)
    end

    local function thunder()
        mob:delStatusEffect(xi.effect.ICE_SPIKES)
        mob:addStatusEffect(xi.effect.SHOCK_SPIKES, damage, 0, 0)
        mob:setLocalVar("addDMG", 3)
    end

    local function performMagicPhase(magicFunc, effectToRemove)
        if effectToRemove ~= nil then
            mob:delStatusEffect(effectToRemove)
        end
        magicFunc()
        mob:setLocalVar("fightTIME", mob:getBattleTime())
        mob:setLocalVar("MAGICphase", (MAGICphase % 3) + 1)
        mob:useMobAbility(624) -- Dust cloud
    end

    isBusy = act == xi.act.MOBABILITY_START or
        act == xi.act.MOBABILITY_USING or
        act == xi.act.MOBABILITY_FINISH or
        act == xi.act.MAGIC_CASTING or
        act == xi.act.MAGIC_START or
        act == xi.act.MAGIC_FINISH

    -- Conditional for magic phase changes
    if mob:actionQueueEmpty() and not isBusy then
        if MAGICphase == 0 then
            mob:setLocalVar("fightTIME", mob:getBattleTime())
            mob:setLocalVar("MAGICphase", 1)
        elseif mob:getBattleTime() - fightTIME > intervalTIME then
            performMagicPhase(
                MAGICphase == 1 and fire or
                MAGICphase == 2 and ice or
                MAGICphase == 3 and thunder
            )
        end
    end

    if lifePercent <= 51 and phase == 0 then
        mob:setLocalVar("phase", 1)
    end

    if mob:actionQueueEmpty() and not isBusy then
        if phase == 3 then
            if os.time() > deathRecast then
                mob:castSpell(367, target) -- death spell
                mob:setLocalVar("deathRecast", os.time() + math.random(90, 120)) -- 1.5 - 2 mins
            end
        end
    end

    -- Unlock death spell, switch to dangerous mob skills, and spawn Jackpotolox
    if phase == 1 then
        local startTime = mob:getLocalVar("startTime")
        local endTime = mob:getLocalVar("endTime")
        local zone = mob:getZone()
        local goblin = zone:insertDynamicEntity({
            objtype = xi.objType.MOB,
            name = "Jackpotolox",
            x = mob:getXPos() - 1,
            y = mob:getYPos(),
            z = mob:getZPos() - 2,
            rotation = mob:getRotPos(),
            look = 1087, -- Goblin
            groupId = 14,
            groupZoneId = 127,

            onMobSpawn = function(mob)
                mob:addImmunity(xi.immunity.STUN)
                mob:addImmunity(xi.immunity.BLIND)
                mob:addImmunity(xi.immunity.BIND)
                mob:addImmunity(xi.immunity.GRAVITY)
                mob:addImmunity(xi.immunity.DARK_SLEEP)
                mob:addImmunity(xi.immunity.POISON)
                mob:addImmunity(xi.immunity.PARALYZE)
                mob:addImmunity(xi.immunity.LIGHT_SLEEP)
                mob:setMod(xi.mod.FIRE_MEVA, 150)
                mob:setMod(xi.mod.ICE_MEVA, 150)
                mob:setMod(xi.mod.WIND_MEVA, 150)
                mob:setMod(xi.mod.EARTH_MEVA, 150)
                mob:setMod(xi.mod.THUNDER_MEVA, 50)
                mob:setMod(xi.mod.WATER_MEVA, 150)
                mob:setMod(xi.mod.LIGHT_MEVA, 150)
                mob:setMod(xi.mod.DARK_MEVA, 150)
                mob:setMod(xi.mod.FIRE_SDT, 150)
                mob:setMod(xi.mod.ICE_SDT, 150)
                mob:setMod(xi.mod.WIND_SDT, 150)
                mob:setMod(xi.mod.EARTH_SDT, 150)
                mob:setMod(xi.mod.THUNDER_SDT, 50)
                mob:setMod(xi.mod.WATER_SDT, 150)
                mob:setMod(xi.mod.LIGHT_SDT, 150)
                mob:setMod(xi.mod.DARK_SDT, 150)
                mob:addMod(xi.mod.MDEF, 20)
                mob:addStatusEffect(xi.effect.REGAIN, 15, 3, 0)
                mob:addStatusEffect(xi.effect.MIGHTY_STRIKES, 1, 0, 0)
                mob:setLocalVar("startTime", mob:getBattleTime())

                if math.random(1, 2) > 1 then
                    mob:addStatusEffectEx(xi.effect.PHYSICAL_SHIELD, 1, 1, 0, 0)
                else
                    mob:addStatusEffectEx(xi.effect.MAGIC_SHIELD, 1, 1, 0, 0)
                end

                local startWSgoblin = mob:getLocalVar("startWSgoblin")
                -- Open each fight immediately with frypan
                mob:addListener("ENGAGE", "openWSgoblin", function(mob)
                    mob:setTP(3000)
                    mob:useMobAbility(1081) -- frypan
                    mob:setLocalVar("startWSgoblin", 1)
                end)

                if startWSgoblin == 1 then
                    mob:removeListener("openWSgoblin")
                end
            end,

            -- Clean up DE if parent is nil
            onMobRoam = function(mob)
                local Arch = GetMobByID(17543469)

                if not Arch:isAlive() then
                    DespawnMob(mob:getID())
                end
            end,

            onMobFight = function(mob, target)
                local Arch = GetMobByID(17543469)

                if not Arch:isAlive() then
                    DespawnMob(mob:getID())
                end

                if mob:getBattleTime() - startTime > 30 then -- Countdown for Jackpotolox to KO
                    mob:useMobAbility(592) -- Suicide bomb toss
                end
            end,

            onMobDeath = function(mob, playerArg, isKiller)
                local Arch = GetMobByID(17543469)

                if mob:getBattleTime() < 31 then
                    Arch:setDropID(3968) -- High quality pool
                    Arch:addStatusEffect(xi.effect.TERROR, 0, 0, 15)
                    Arch:weaknessTrigger(3)
                elseif mob:getBattleTime() > 31 then
                    Arch:setDropID(3967) -- Normal quality pool
                end
            end,

            releaseIdOnDeath = true,
            specialSpawnAnimation = true,
        })

        goblin:setSpawn(mob:getXPos() - 1, mob:getYPos(), mob:getZPos() - 2, mob:getRotPos())
        goblin:setDropID(0) -- No loot!
        goblin:setMobAbilityEnabled(false) -- Scripted event, we don't need skills here.
        goblin:spawn()
        goblin:updateEnmity(mob:getTarget())
        mob:setLocalVar("phase", 2)
    end

    if phase == 2 then
        mob:useMobAbility(624) -- Dust cloud
        mob:setMobMod(xi.mobMod.SKILL_LIST, 5023) -- Stronger mob skills
        mob:setLocalVar("phase", 3)
    end

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 5000
    })
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onSpellPrecast", function(mob, spell)
    if spell:getID() == 252 then -- stun
        spell:setAoE(xi.magic.aoe.RADIAL)
        spell:setFlag(xi.magic.spellFlag.HIT_ALL)
        spell:setRadius(30)
    end
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onMobDespawn", function(mob)
    mob:resetLocalVars()
end)

m:addOverride("xi.zones.Dynamis-Windurst.mobs.Arch_Tzee_Xicu_Idol.onMobDeath", function(mob, player, optParams)
    mob:resetLocalVars()
end)

return m
