-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Valkurm
--  Mob: Stcemqestcint
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_stcemqestcint")

xi.module.ensureTable("xi.zones.Dynamis-Valkurm.mobs.Stcemqestcint")

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Stcemqestcint.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 50)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 50)
    mob:setMod(xi.mod.FIRE_SDT, 50)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 50)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 5, 3, 0)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Stcemqestcint.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Stcemqestcint.onMobFight", function(mob, target)
    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3500
    })
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Stcemqestcint.onMobDeath", function(mob, player, optParams)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Stcemqestcint.onMobDespawn", function(mob)
    mob:resetLocalVars()
end)

return m
