-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Valkurm
-- Mob: Lost_Lost_Nantina
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------

local m = Module:new("dyna_2_0_lost_nantina")

xi.module.ensureTable("xi.zones.Dynamis-Valkurm.mobs.Lost_Nantina")

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Lost_Nantina.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 50)
    mob:setMod(xi.mod.ICE_MEVA, 90)
    mob:setMod(xi.mod.WIND_MEVA, 90)
    mob:setMod(xi.mod.EARTH_MEVA, 90)
    mob:setMod(xi.mod.THUNDER_MEVA, 50)
    mob:setMod(xi.mod.WATER_MEVA, 90)
    mob:setMod(xi.mod.LIGHT_MEVA, 90)
    mob:setMod(xi.mod.DARK_MEVA, 90)
    mob:setMod(xi.mod.FIRE_SDT, 50)
    mob:setMod(xi.mod.ICE_SDT, 90)
    mob:setMod(xi.mod.WIND_SDT, 90)
    mob:setMod(xi.mod.EARTH_SDT, 90)
    mob:setMod(xi.mod.THUNDER_SDT, 50)
    mob:setMod(xi.mod.WATER_SDT, 90)
    mob:setMod(xi.mod.LIGHT_SDT, 90)
    mob:setMod(xi.mod.DARK_SDT, 90)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addMod(xi.mod.ATT, 75)
    mob:addStatusEffect(xi.effect.REGAIN, 150, 0, 0)
    mob:setAutoAttackEnabled(false)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Lost_Nantina.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    mob:setLocalVar("wsOrder", 1)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Lost_Nantina.onMobFight", function(mob, target)
    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 4000
    })
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Lost_Nantina.onMobWeaponSkillPrepare", function(mob, target)
    local wsOrder = mob:getLocalVar("wsOrder")
    local isBusy = false
    local act = mob:getCurrentAction()
    local mobskill = {
         581, -- blow
         584, -- uppercut
        1619, -- attractant
    }

    isBusy = act == xi.act.MOBABILITY_START or
             act == xi.act.MOBABILITY_USING or
             act == xi.act.MOBABILITY_FINISH or
             act == xi.act.MAGIC_CASTING or
             act == xi.act.MAGIC_START or
             act == xi.act.MAGIC_FINISH

    if mob:actionQueueEmpty() and not isBusy then
        if wsOrder == 1 then
            mob:setLocalVar("wsOrder", 2)
            return mobskill[1]
        elseif wsOrder == 2 then
            mob:setLocalVar("wsOrder", 3)
            return mobskill[1]
        elseif wsOrder == 3 then
            mob:setLocalVar("wsOrder", 4)
            return mobskill[1]
        elseif wsOrder == 4 then
            mob:setLocalVar("wsOrder", 5)
            return mobskill[2]
        elseif wsOrder == 5 then
            mob:setLocalVar("wsOrder", 6)
            return mobskill[2]
        elseif wsOrder == 6 then
            mob:setLocalVar("wsOrder", 7)
            return mobskill[2]
        elseif wsOrder == 7 then
            mob:setLocalVar("wsOrder", 1)
            return mobskill[3]
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Lost_Nantina.onMobDeath", function(mob, player, optParams)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Lost_Nantina.onMobDespawn", function(mob)
    mob:resetLocalVars()
end)

return m
