-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Valkurm
--  Mob: Cirrate Christelle
-- Note: This monster has unique interactions with itemIDs 5895, 5896 and 5897.
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_cirrate_christelle")

xi.module.ensureTable("xi.zones.Dynamis-Valkurm.mobs.Cirrate_Christelle")

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Cirrate_Christelle.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 50)
    mob:setMod(xi.mod.ICE_MEVA, 150)
    mob:setMod(xi.mod.WIND_MEVA, 150)
    mob:setMod(xi.mod.EARTH_MEVA, 150)
    mob:setMod(xi.mod.THUNDER_MEVA, 150)
    mob:setMod(xi.mod.WATER_MEVA, 150)
    mob:setMod(xi.mod.LIGHT_MEVA, 150)
    mob:setMod(xi.mod.DARK_MEVA, 150)
    mob:setMod(xi.mod.FIRE_SDT, 50)
    mob:setMod(xi.mod.ICE_SDT, 150)
    mob:setMod(xi.mod.WIND_SDT, 150)
    mob:setMod(xi.mod.EARTH_SDT, 150)
    mob:setMod(xi.mod.THUNDER_SDT, 150)
    mob:setMod(xi.mod.WATER_SDT, 150)
    mob:setMod(xi.mod.LIGHT_SDT, 150)
    mob:setMod(xi.mod.DARK_SDT, 150)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addStatusEffect(xi.effect.REGAIN, 10, 3, 0)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Cirrate_Christelle.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    mob:addListener("EFFECT_GAIN", "fungusUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.STR_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("fungus", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "mossUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.DEX_BOOST then
            mob:weaknessTrigger(2)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("moss", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "rootUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.VIT_BOOST then
            mob:weaknessTrigger(3)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("root", 1)
        end
    end)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Cirrate_Christelle.onMobFight", function(mob, target)
    local fungus = mob:getLocalVar("fungus")
    local moss   = mob:getLocalVar("moss")
    local root   = mob:getLocalVar("root")

    if fungus == 1 then
        mob:removeListener("fungusUSE")
        mob:addStatusEffect(xi.effect.WEIGHT, 50, 0, 3000)
        mob:setLocalVar("fungus", 2)
    end

    if moss == 1 then
        mob:removeListener("mossUSE")
        mob:setLocalVar("moss", 2)
    end

    if root == 1 then
        mob:removeListener("rootUSE")
        mob:setLocalVar("root", 2)
    end

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 3500
    })
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Cirrate_Christelle.onMobWeaponSkillPrepare", function(mob, target)
    local fungus = mob:getLocalVar("fungus")
    local moss   = mob:getLocalVar("moss")
    local root   = mob:getLocalVar("root")
    local availableSkills = {317, 1332, 1605, 1607, 1609}

    -- Check and remove skills based on conditions
    if fungus == 2 then
        for i = #availableSkills, 1, -1 do
            if availableSkills[i] == 1605 then
                table.remove(availableSkills, i)
            end
        end
    end

    if moss == 2 then
        for i = #availableSkills, 1, -1 do
            if availableSkills[i] == 1607 then
                table.remove(availableSkills, i)
            end
        end
    end

    if root == 2 then
        for i = #availableSkills, 1, -1 do
            if availableSkills[i] == 1332 then
                table.remove(availableSkills, i)
            end
        end
    end

    -- If none of the conditions are met, availableSkills remains unchanged

    if #availableSkills > 0 then
        local randomIndex = math.random(1, #availableSkills)
        local selectedSkill = availableSkills[randomIndex]
        return selectedSkill
    else
        return 0 -- No available skills, return 0 or handle as needed
    end
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Cirrate_Christelle.onMobDeath", function(mob, player, optParams)
    xi.dynamis.megaBossOnDeath(mob, player, optParams)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Cirrate_Christelle.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("fungusUSE")
    mob:removeListener("mossUSE")
    mob:removeListener("rootUSE")
end)

return m
