-----------------------------------
-- CatsEyeXI Dynamis 2.0
-- Area: Dynamis - Valkurm
--  Mob: Arch_Christelle
-- Note: This monster has unique interactions with itemIDs 5895, 5896 and 5897.
-----------------------------------
require("modules/module_utils")
require("scripts/mixins/rage")
local cms  = require("modules/catseyexi/lua/additive_overrides/utils/custom_mob_scaler")
-----------------------------------
local m = Module:new("dyna_2_0_arch_christelle")

xi.module.ensureTable("xi.zones.Dynamis-Valkurm.mobs.Arch_Christelle")

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Arch_Christelle.onMobInitialize", function(mob)
    g_mixins.rage(mob)
    mob:setMobMod(xi.mobMod.IDLE_DESPAWN, 300)
    mob:addImmunity(xi.immunity.SILENCE)
    mob:addImmunity(xi.immunity.DARK_SLEEP)
    mob:addImmunity(xi.immunity.LIGHT_SLEEP)
    mob:setMod(xi.mod.FIRE_MEVA, 50)
    mob:setMod(xi.mod.ICE_MEVA, 90)
    mob:setMod(xi.mod.WIND_MEVA, 90)
    mob:setMod(xi.mod.EARTH_MEVA, 90)
    mob:setMod(xi.mod.THUNDER_MEVA, 90)
    mob:setMod(xi.mod.WATER_MEVA, 90)
    mob:setMod(xi.mod.LIGHT_MEVA, 90)
    mob:setMod(xi.mod.DARK_MEVA, 90)
    mob:setMod(xi.mod.FIRE_SDT, 50)
    mob:setMod(xi.mod.ICE_SDT, 100)
    mob:setMod(xi.mod.WIND_SDT, 100)
    mob:setMod(xi.mod.EARTH_SDT, 100)
    mob:setMod(xi.mod.THUNDER_SDT, 100)
    mob:setMod(xi.mod.WATER_SDT, 100)
    mob:setMod(xi.mod.LIGHT_SDT, 100)
    mob:setMod(xi.mod.DARK_SDT, 100)
    mob:addMod(xi.mod.MDEF, 20)
    mob:addMod(xi.mod.DEF, 20)
    mob:addMod(xi.mod.ATT, 125)
    mob:setMod(xi.mod.DOUBLE_ATTACK, 25)
    mob:addStatusEffect(xi.effect.REGAIN, 10, 3, 0)
    mob:addMod(xi.mod.AGI, 20)
    mob:addMod(xi.mod.VIT, 20)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Arch_Christelle.onMobSpawn", function(mob)
    mob:setLocalVar("[rage]timer", 900) -- 15 minutes
    mob:addListener("EFFECT_GAIN", "fungusUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.STR_BOOST then
            mob:weaknessTrigger(1)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("fungus", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "mossUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.DEX_BOOST then
            mob:weaknessTrigger(2)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("moss", 1)
        end
    end)

    mob:addListener("EFFECT_GAIN", "rootUSE", function(mob, effect)
         if effect:getEffectType() == xi.effect.VIT_BOOST then
            mob:weaknessTrigger(3)
            mob:addStatusEffect(xi.effect.TERROR, 0, 0, 3)
            mob:setLocalVar("root", 1)
        end
    end)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Arch_Christelle.onMobFight", function(mob, target)
    local fungus = mob:getLocalVar("fungus")
    local moss   = mob:getLocalVar("moss")
    local root   = mob:getLocalVar("root")

    if fungus == 1 then
        mob:removeListener("fungusUSE")
        mob:addStatusEffect(xi.effect.WEIGHT, 50, 0, 3000)
        mob:setLocalVar("fungus", 2)
    end

    if moss == 1 then
        mob:removeListener("mossUSE")
        mob:setLocalVar("moss", 2)
    end

    if root == 1 then
        mob:removeListener("rootUSE")
        mob:setLocalVar("root", 2)
    end

    cms.mobScalerPercentage(mob, target,
    {
        minplayers = 6,
        maxplayers = 18,
        HP         = 5000
    })
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Arch_Christelle.onMobWeaponSkillPrepare", function(mob, target)
    local fungus = mob:getLocalVar("fungus")
    local moss = mob:getLocalVar("moss")
    local root = mob:getLocalVar("root")
    local random = math.random()
    local distributions = {
        [0] = {0.20, 0.40, 0.60, 0.80, 1.00}, -- Default distribution
        [1] = {0.23, 0.31, 0.54, 0.77, 1.00}, -- Combination 001 (root == 2)
        [2] = {0.23, 0.46, 0.69, 0.77, 1.00}, -- Combination 010 (moss == 2)
        [3] = {0.30, 0.35, 0.65, 0.70, 1.00}, -- Combination 011 (moss == 2, root == 2)
        [4] = {0.23, 0.46, 0.54, 0.77, 1.00}, -- Combination 100 (fungus == 2)
        [5] = {0.30, 0.35, 0.40, 0.70, 1.00}, -- Combination 101 (fungus == 2, root == 2)
        [6] = {0.30, 0.60, 0.65, 0.70, 1.00}, -- Combination 110 (fungus == 2, moss == 2)
        [7] = {0.45, 0.47, 0.51, 0.54, 1.00}, -- Combination 111 (fungus == 2, moss == 2, root == 2)
    }

    local combination = (fungus == 2 and 4 or 0) + (moss == 2 and 2 or 0) + (root == 2 and 1 or 0)
    local distribution = distributions[combination]

    for i = 1, #distribution do
        if random <= distribution[i] then
            return (i == 1 and 317) or (i == 2 and 1332) or (i == 3 and 1605) or (i == 4 and 1607) or 1609
        end
    end
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Arch_Christelle.onMobDeath", function(mob, player, optParams)
end)

m:addOverride("xi.zones.Dynamis-Valkurm.mobs.Arch_Christelle.onMobDespawn", function(mob)
    mob:resetLocalVars()
    mob:removeListener("fungusUSE")
    mob:removeListener("mossUSE")
    mob:removeListener("rootUSE")
end)

return m
